/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.ThreadPoolExecutorFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicallySizedThreadPoolExecutorTest
extends TestCase {
    private static Log logger;
    private ThreadPoolExecutorFactoryBean factory;

    protected void setUp() throws Exception {
        this.factory = new ThreadPoolExecutorFactoryBean();
        SleepUntilAllWake.reset();
    }

    public void testUpToCore() throws Exception {
        this.factory.setCorePoolSize(5);
        this.factory.setMaximumPoolSize(10);
        this.factory.afterPropertiesSet();
        DynamicallySizedThreadPoolExecutor exec = (DynamicallySizedThreadPoolExecutor)this.factory.getObject();
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getPoolSize());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
    }

    public void testPastCoreButNotHugeQueue() throws Exception {
        this.factory.setCorePoolSize(5);
        this.factory.setMaximumPoolSize(10);
        this.factory.afterPropertiesSet();
        DynamicallySizedThreadPoolExecutor exec = (DynamicallySizedThreadPoolExecutor)this.factory.getObject();
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)7, (int)exec.getQueue().size());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)5, (int)exec.getPoolSize());
    }

    public void testToExpandQueue() throws Exception {
        this.factory.setCorePoolSize(2);
        this.factory.setMaximumPoolSize(4);
        this.factory.setKeepAliveTime(1);
        this.factory.afterPropertiesSet();
        DynamicallySizedThreadPoolExecutor exec = (DynamicallySizedThreadPoolExecutor)this.factory.getObject();
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)6, (int)exec.getQueue().size());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
    }

    public void offTestToExpandThenContract() throws Exception {
        this.factory.setCorePoolSize(2);
        this.factory.setMaximumPoolSize(4);
        this.factory.setKeepAliveTime(1);
        this.factory.afterPropertiesSet();
        DynamicallySizedThreadPoolExecutor exec = (DynamicallySizedThreadPoolExecutor)this.factory.getObject();
        exec.setKeepAliveTime(30L, TimeUnit.MILLISECONDS);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)6, (int)exec.getQueue().size());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        logger.debug((Object)("Core pool size is " + exec.getCorePoolSize()));
        logger.debug((Object)("Current pool size is " + exec.getPoolSize()));
        logger.debug((Object)("Queue size is " + exec.getQueue().size()));
        DynamicallySizedThreadPoolExecutorTest.assertTrue((String)("Pool size should be 0-2 as everything is idle, was " + exec.getPoolSize()), (exec.getPoolSize() >= 0 ? 1 : 0) != 0);
        DynamicallySizedThreadPoolExecutorTest.assertTrue((String)("Pool size should be 0-2 as everything is idle, was " + exec.getPoolSize()), (exec.getPoolSize() <= 2 ? 1 : 0) != 0);
        SleepUntilAllWake.reset();
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)3, (int)exec.getQueue().size());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)2, (int)exec.getPoolSize());
        exec.setCorePoolSize(1);
        SleepUntilAllWake.reset();
        exec.execute(new SleepUntilAllWake());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)1, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)0, (int)exec.getQueue().size());
        SleepUntilAllWake.reset();
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        exec.execute(new SleepUntilAllWake());
        Thread.sleep(20L);
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)4, (int)exec.getPoolSize());
        DynamicallySizedThreadPoolExecutorTest.assertEquals((int)6, (int)exec.getQueue().size());
        SleepUntilAllWake.wakeAll();
        Thread.sleep(100L);
        DynamicallySizedThreadPoolExecutorTest.assertTrue((String)("Pool size should be 0 or 1 as everything is idle, was " + exec.getPoolSize()), (exec.getPoolSize() >= 0 ? 1 : 0) != 0);
        DynamicallySizedThreadPoolExecutorTest.assertTrue((String)("Pool size should be 0 or 1 as everything is idle, was " + exec.getPoolSize()), (exec.getPoolSize() <= 1 ? 1 : 0) != 0);
    }

    static {
        if (!ApplicationContextHelper.isContextLoaded()) {
            ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/logging-context.xml"});
        }
        logger = LogFactory.getLog(DynamicallySizedThreadPoolExecutorTest.class);
    }

    public static class SleepUntilAllWake
    implements Runnable {
        private static ArrayList<Thread> sleeping = new ArrayList();
        private static boolean allAwake = false;

        public void run() {
            if (allAwake) {
                return;
            }
            sleeping.add(Thread.currentThread());
            try {
                Thread.sleep(30000L);
                System.err.println("Warning - Thread finished sleeping without wake!");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public static void wakeAll() {
            allAwake = true;
            for (Thread t : sleeping) {
                t.interrupt();
            }
        }

        public static void reset() {
            allAwake = false;
            sleeping.clear();
        }
    }
}

