/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server.socket;

import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostConfigurableSocketFactory
implements RMIServerSocketFactory,
RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(HostConfigurableSocketFactory.class);
    private int retries = 0;
    private int retryInterval = 250;
    private InetAddress host;

    public void setHost(String host) {
        try {
            InetAddress hostAddress = InetAddress.getByName(host);
            if (!hostAddress.isAnyLocalAddress()) {
                this.host = hostAddress;
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket socket = null;
        for (int i = 0; socket == null && i < this.retries + 1; ++i) {
            try {
                socket = new ServerSocket(port, 50, this.host);
                continue;
            }
            catch (BindException e) {
                if (i >= this.retries) {
                    throw e;
                }
                logger.warn((Object)"Port in-use, retrying", (Throwable)e);
                try {
                    Thread.sleep(this.retryInterval);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof HostConfigurableSocketFactory && EqualsHelper.nullSafeEquals((Object)this.host, (Object)((HostConfigurableSocketFactory)obj).host);
    }

    public int hashCode() {
        return this.host == null ? 0 : this.host.hashCode();
    }
}

