/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.Arrays;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DbPropertyTest {
    @Test(expected=IllegalArgumentException.class)
    public void cannotHaveNullDbObject() {
        new DbProperty(null, "theProperty");
    }

    @Test
    public void propertyValueCanBeRetrievedByReflection() {
        DbObjectWithIndexedProp dbo = (DbObjectWithIndexedProp)Mockito.mock(DbObjectWithIndexedProp.class);
        Mockito.when((Object)dbo.getTheProperty()).thenReturn((Object)"This is the property value");
        DbProperty dbProperty = new DbProperty(dbo, "theProperty");
        Assert.assertEquals((Object)"This is the property value", (Object)dbProperty.getPropertyValue());
    }

    @Test
    public void indexedPropertyValueCanBeRetrievedByReflection() {
        DbObjectWithIndexedProp dbo = (DbObjectWithIndexedProp)Mockito.mock(DbObjectWithIndexedProp.class);
        Mockito.when(dbo.getColours()).thenReturn(Arrays.asList("red", "green", "blue"));
        DbProperty greenProperty = new DbProperty(dbo, "colours[1]");
        DbProperty blueProperty = new DbProperty(dbo, "colours", 2);
        Assert.assertEquals((Object)"green", (Object)greenProperty.getPropertyValue());
        Assert.assertEquals((Object)"blue", (Object)blueProperty.getPropertyValue());
    }

    @Test
    public void canGetPath() {
        new MyDbObject("root", 1).add(new MyDbObject("child", 2)).add(new MyDbObject("grandchild", 3)).add(new MyDbObject("greatgrandchild", 4));
        DbProperty levelProp = new DbProperty(MyDbObject.lastAdded, "level");
        Assert.assertEquals((String)"Incorrect path", (Object)"root.child.grandchild.greatgrandchild.level", (Object)levelProp.getPath());
        DbProperty greatGrandChildProp = new DbProperty(MyDbObject.lastAdded);
        Assert.assertEquals((String)"Incorrect path", (Object)"root.child.grandchild.greatgrandchild", (Object)greatGrandChildProp.getPath());
    }

    public static class MyDbObject
    extends AbstractDbObject {
        public static MyDbObject lastAdded;
        private int level;

        public MyDbObject(String name, int level) {
            super(null, name);
            this.level = level;
        }

        public void accept(DbObjectVisitor visitor) {
        }

        public MyDbObject add(MyDbObject child) {
            child.setParent(this);
            lastAdded = child;
            return child;
        }

        public int getLevel() {
            return this.level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DbObjectWithIndexedProp
    extends DbObject {
        public String getTheProperty();

        public List<String> getColours();
    }
}

