/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.SchemaToXML;
import org.alfresco.util.schemacomp.model.Schema;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DbToXML {
    private ApplicationContext context;
    private File outputFile;
    private String namePrefix = "alf_";

    public DbToXML(ApplicationContext context, File outputFile) {
        this.context = context;
        this.outputFile = outputFile;
    }

    public DbToXML(ApplicationContext context, File outputFile, String namePrefix) {
        this(context, outputFile);
        this.namePrefix = namePrefix;
    }

    public void execute() {
        ExportDb exporter = null;
        try {
            exporter = new ExportDb(this.context);
            exporter.setNamePrefix(this.namePrefix);
            exporter.execute();
        }
        catch (Exception e) {
            System.err.println("Unable to read database schema.");
            e.printStackTrace();
            System.exit(1);
        }
        if (exporter != null) {
            Schema schema = exporter.getSchema();
            StringWriter stringWriter = new StringWriter();
            SchemaToXML schemaToXML = new SchemaToXML(schema, new StreamResult(stringWriter));
            schemaToXML.execute();
            this.writeToFile(stringWriter.getBuffer().toString());
        }
    }

    private void writeToFile(String content) {
        String[] lines;
        PrintWriter pw = DbToXML.printWriter(this.outputFile, "UTF-8", "\r\n");
        for (String line : lines = content.split(System.getProperty("line.separator"))) {
            pw.println(line);
        }
        pw.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrintWriter printWriter(File file, String charSet, String lineSeparator) {
        Properties props;
        Properties properties = props = System.getProperties();
        synchronized (properties) {
            PrintWriter printWriter;
            String oldLineSep = null;
            try {
                try {
                    oldLineSep = (String)props.setProperty("line.separator", lineSeparator);
                    printWriter = new PrintWriter(file, charSet);
                    Object var8_9 = null;
                    if (oldLineSep == null) return printWriter;
                    props.put("line.separator", oldLineSep);
                }
                catch (FileNotFoundException error) {
                    throw new RuntimeException("Unable to write to file " + file, error);
                }
                catch (UnsupportedEncodingException error) {
                    throw new RuntimeException("Unsupported encoding" + charSet, error);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (oldLineSep == null) throw throwable;
                props.put("line.separator", oldLineSep);
                throw throwable;
            }
            return printWriter;
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage:");
            System.err.println("java " + DbToXML.class.getName() + " <context.xml> <output.xml>");
            System.exit(1);
        }
        String contextPath = args[0];
        File outputFile = new File(args[1]);
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(contextPath);
        DbToXML dbToXML = new DbToXML((ApplicationContext)context, outputFile);
        dbToXML.execute();
        context.close();
    }
}

