/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Difference;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.model.DbObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComparisonUtils
implements ComparisonUtils {
    @Override
    public List<DbObject> findEquivalentObjects(DbObject rootObject, DbObject objToMatch) {
        EquivalentObjectSeeker objectSeeker = new EquivalentObjectSeeker(objToMatch);
        rootObject.accept(objectSeeker);
        return objectSeeker.getMatches();
    }

    @Override
    public void compareSimpleCollections(DbProperty leftProp, DbProperty rightProp, DiffContext ctx, Result.Strength strength) {
        Collection leftCollection = (Collection)leftProp.getPropertyValue();
        Collection rightCollection = (Collection)rightProp.getPropertyValue();
        ArrayList leftList = new ArrayList(leftCollection);
        ArrayList rightList = new ArrayList(rightCollection);
        Results differences = ctx.getComparisonResults();
        for (int leftIndex = 0; leftIndex < leftList.size(); ++leftIndex) {
            Object leftObj = leftList.get(leftIndex);
            DbProperty leftIndexedProp = new DbProperty(leftProp.getDbObject(), leftProp.getPropertyName(), leftIndex);
            int rightIndex = rightList.indexOf(leftObj);
            if (rightIndex != -1) {
                DbProperty rightIndexedProp = new DbProperty(rightProp.getDbObject(), rightProp.getPropertyName(), rightIndex);
                differences.add(Difference.Where.IN_BOTH_NO_DIFFERENCE, leftIndexedProp, rightIndexedProp, strength);
                continue;
            }
            differences.add(Difference.Where.ONLY_IN_REFERENCE, leftIndexedProp, rightProp, strength);
        }
        for (int rightIndex = 0; rightIndex < rightList.size(); ++rightIndex) {
            Object rightObj = rightList.get(rightIndex);
            if (leftCollection.contains(rightObj)) continue;
            DbProperty rightIndexedProp = new DbProperty(rightProp.getDbObject(), rightProp.getPropertyName(), rightIndex);
            differences.add(Difference.Where.ONLY_IN_TARGET, leftProp, rightIndexedProp, strength);
        }
    }

    @Override
    public void compareCollections(Collection<? extends DbObject> leftCollection, Collection<? extends DbObject> rightCollection, DiffContext ctx) {
        this.compareCollections(leftCollection, rightCollection, ctx, null);
    }

    @Override
    public void compareCollections(Collection<? extends DbObject> leftCollection, Collection<? extends DbObject> rightCollection, DiffContext ctx, Result.Strength strength) {
        List<DbObject> matches;
        boolean foundMatch;
        Results differences = ctx.getComparisonResults();
        for (DbObject dbObject : leftCollection) {
            foundMatch = false;
            for (DbObject dbObject2 : rightCollection) {
                matches = this.findEquivalentObjects(dbObject2, dbObject);
                for (DbObject match : matches) {
                    dbObject.diff(match, ctx, strength);
                }
                if (matches.size() <= 0) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            differences.add(Difference.Where.ONLY_IN_REFERENCE, new DbProperty(dbObject, null), null, strength);
        }
        for (DbObject dbObject : rightCollection) {
            foundMatch = false;
            for (DbObject dbObject3 : leftCollection) {
                matches = this.findEquivalentObjects(dbObject3, dbObject);
                if (matches.size() <= 0) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            differences.add(Difference.Where.ONLY_IN_TARGET, null, new DbProperty(dbObject, null), strength);
        }
    }

    @Override
    public void compareSimple(DbProperty left, DbProperty right, DiffContext ctx) {
        this.compareSimple(left, right, ctx, null);
    }

    @Override
    public void compareSimple(DbProperty leftProperty, DbProperty rightProperty, DiffContext ctx, Result.Strength strength) {
        Difference.Where where = null;
        Object left = leftProperty.getPropertyValue();
        this.checkNotDbObject(left);
        Object right = rightProperty.getPropertyValue();
        this.checkNotDbObject(right);
        where = left == right ? Difference.Where.IN_BOTH_NO_DIFFERENCE : (left == null ? Difference.Where.ONLY_IN_TARGET : (right == null ? Difference.Where.ONLY_IN_REFERENCE : (left.equals(right) ? Difference.Where.IN_BOTH_NO_DIFFERENCE : Difference.Where.IN_BOTH_BUT_DIFFERENCE)));
        ctx.getComparisonResults().add(where, leftProperty, rightProperty, strength);
    }

    private void checkNotDbObject(Object obj) {
        if (obj != null && DbObject.class.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Property value is a DbObject - this method shouldn't be used to compare this type: " + obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EquivalentObjectSeeker
    implements DbObjectVisitor {
        private final List<DbObject> matches = new ArrayList<DbObject>();
        private final DbObject objToMatch;

        public EquivalentObjectSeeker(DbObject objToMatch) {
            this.objToMatch = objToMatch;
        }

        @Override
        public void visit(DbObject dbObject) {
            if (this.objToMatch.sameAs(dbObject)) {
                this.matches.add(dbObject);
            }
        }

        public List<DbObject> getMatches() {
            return this.matches;
        }
    }
}

