/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.Arrays;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexTest
extends DbObjectTestBase<Index> {
    private Table thisTable;
    private Index thisIndex;
    private Table thatTable;
    private Index thatIndex;

    @Before
    public void setUp() {
        this.thisTable = new Table("this_table");
        this.thisIndex = new Index(this.thisTable, "this_index", Arrays.asList("id", "name", "age"));
        this.thatTable = new Table("that_table");
        this.thatIndex = new Index(this.thatTable, "that_index", Arrays.asList("a", "b"));
    }

    @Override
    protected Index getThisObject() {
        return this.thisIndex;
    }

    @Override
    protected Index getThatObject() {
        return this.thatIndex;
    }

    @Override
    protected void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimpleCollections(new DbProperty(this.thisIndex, "columnNames"), new DbProperty(this.thatIndex, "columnNames"), this.ctx, Result.Strength.ERROR);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(new DbProperty(this.thisIndex, "unique"), new DbProperty(this.thatIndex, "unique"), this.ctx);
    }

    @Test
    public void differentNamesResultInWarningsNotErrors() {
        Assert.assertEquals((String)"Name differences should be reported as warnings.", (Object)((Object)Result.Strength.WARN), (Object)((Object)this.thisIndex.getNameStrength()));
    }

    @Test
    public void sameAs() {
        Assert.assertTrue((String)"Indexes should be logically the same.", (boolean)this.thisIndex.sameAs(new Index(this.thisTable, "this_index", Arrays.asList("id", "name", "age"))));
        Assert.assertFalse((String)"Indexes have logically different parents", (boolean)this.thisIndex.sameAs(new Index(this.thatTable, "this_index", Arrays.asList("id", "name", "age"))));
        Assert.assertTrue((String)"Indexes should be logically the same, despite different names (as same column order)", (boolean)this.thisIndex.sameAs(new Index(this.thisTable, "different_name", Arrays.asList("id", "name", "age"))));
        Assert.assertTrue((String)"Indexes should be identified as the same despite different column order (as same name).", (boolean)this.thisIndex.sameAs(new Index(this.thisTable, "this_index", Arrays.asList("name", "id", "age"))));
        Assert.assertFalse((String)"Indexes should be identified different (different name and column order)", (boolean)this.thisIndex.sameAs(new Index(this.thisTable, "different_name", Arrays.asList("name", "id", "age"))));
        Assert.assertFalse((String)"Indexes should be identified different (different name & different columns)", (boolean)this.thisIndex.sameAs(new Index(this.thisTable, "different_name", Arrays.asList("node_ref", "url"))));
    }

    @Test
    public void acceptVisitor() {
        this.thisIndex.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit(this.thisIndex);
    }
}

