/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema
extends AbstractDbObject
implements Iterable<DbObject> {
    protected final List<DbObject> objects = new ArrayList<DbObject>();

    public Schema(String name) {
        super(null, name);
    }

    public void add(DbObject dbObject) {
        dbObject.setParent(this);
        this.objects.add(dbObject);
    }

    @Override
    public Iterator<DbObject> iterator() {
        return this.objects.iterator();
    }

    public boolean contains(DbObject object) {
        return this.objects.contains(object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.objects == null ? 0 : ((Object)this.objects).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        return !(this.objects == null ? other.objects != null : !((Object)this.objects).equals(other.objects));
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx, Result.Strength strength) {
        Schema rightSchema = (Schema)right;
        this.comparisonUtils.compareCollections(this.objects, rightSchema.objects, ctx);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
        for (DbObject child : this.objects) {
            child.accept(visitor);
        }
    }
}

