/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class TableTest
extends DbObjectTestBase<Table> {
    private Table table;
    private Table otherTable;
    private List<Column> columns;
    @Mock
    private PrimaryKey primaryKey;
    private List<ForeignKey> foreignKeys;
    private List<Index> indexes;

    @Before
    public void setUp() throws Exception {
        this.columns = this.listOfMocks(Column.class, 3);
        this.foreignKeys = this.listOfMocks(ForeignKey.class, 1);
        this.indexes = this.listOfMocks(Index.class, 1);
        this.table = new Table(null, "the_table", this.columns, this.primaryKey, this.foreignKeys, this.indexes);
        this.otherTable = new Table(null, "the_other_table", this.columns, this.primaryKey, this.foreignKeys, this.indexes);
    }

    private <T> List<T> listOfMocks(Class<T> c, int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Mockito.mock(c));
        }
        return list;
    }

    @Override
    protected List<Object> getMocksUsedInDiff() {
        List<Object> mocks = super.getMocksUsedInDiff();
        mocks.add(this.primaryKey);
        return mocks;
    }

    @Override
    public void doDiffTests() {
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareCollections(this.table.getColumns(), this.otherTable.getColumns(), this.ctx);
        ((PrimaryKey)this.inOrder.verify((Object)this.primaryKey)).diff(this.otherTable.getPrimaryKey(), this.ctx, Result.Strength.ERROR);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareCollections(this.table.getForeignKeys(), this.otherTable.getForeignKeys(), this.ctx);
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareCollections(this.table.getIndexes(), this.otherTable.getIndexes(), this.ctx);
    }

    @Override
    protected Table getThisObject() {
        return this.table;
    }

    @Override
    protected Table getThatObject() {
        return this.otherTable;
    }

    @Test
    public void acceptVisitor() {
        this.table.setColumns(this.columns);
        this.table.setForeignKeys(this.foreignKeys);
        this.table.setIndexes(this.indexes);
        this.table.setPrimaryKey(this.primaryKey);
        this.table.accept(this.visitor);
        ArrayList<AbstractDbObject> children = new ArrayList<AbstractDbObject>();
        children.addAll(this.columns);
        children.addAll(this.foreignKeys);
        children.addAll(this.indexes);
        children.add(this.primaryKey);
        for (DbObject dbObject : children) {
            ((DbObject)Mockito.verify((Object)dbObject)).accept(this.visitor);
        }
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit(this.table);
    }
}

