/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.test.exportdb;

import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Schema;
import org.junit.Assert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractExportTester {
    protected ExportDb exporter;
    protected PlatformTransactionManager tx;
    protected SimpleJdbcTemplate jdbcTemplate;

    public AbstractExportTester(ExportDb exporter, PlatformTransactionManager tx, SimpleJdbcTemplate jdbcTemplate) {
        this.exporter = exporter;
        this.tx = tx;
        this.jdbcTemplate = jdbcTemplate;
    }

    protected abstract void doExportTest() throws Exception;

    protected abstract void doDatabaseSetup();

    public void runExportTest() throws Exception {
        this.doDatabaseSetup();
        this.exporter.execute();
        System.out.println(this.getSchema());
        this.commonPostExportChecks();
        this.doExportTest();
    }

    protected void commonPostExportChecks() {
        Schema schema = this.getSchema();
        Assert.assertNull((String)"Schema shouldn't have a parent", (Object)this.getSchema().getParent());
        this.checkResultsFiltered(schema, "export_test_");
    }

    public Schema getSchema() {
        return this.exporter.getSchema();
    }

    protected void checkResultsFiltered(Schema schema, String prefix) {
        for (DbObject dbo : schema) {
            if (dbo.getName().startsWith(prefix)) continue;
            Assert.fail((String)("Database object's name does not start with '" + prefix + "': " + dbo));
        }
    }
}

