/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AbstractWCMServiceImplTest
extends TestCase {
    protected static Log logger = LogFactory.getLog(AbstractWCMServiceImplTest.class);
    private static final String PREVIEW_CONFIG_LOCATION = "classpath:wcm/wcm-test-preview-context.xml";
    private static final String SUBMIT_CONFIG_LOCATION = "classpath:wcm/wcm-jbpm-context.xml";
    protected static final long POLL_DELAY = 1500L;
    protected static final int POLL_MAX_ATTEMPTS = 200;
    protected static ApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:wcm/wcm-jbpm-context.xml", "classpath:wcm/wcm-test-preview-context.xml"});
    protected static final String TEST_RUN = "" + System.currentTimeMillis();
    protected static final boolean CLEAN = true;
    protected static final String TEST_WEBPROJ_DNS = "testWP-" + TEST_RUN;
    protected static final String TEST_WEBPROJ_NAME = "testSandbox Web Project Display Name - " + TEST_RUN;
    protected static final String TEST_WEBPROJ_TITLE = "This is my title";
    protected static final String TEST_WEBPROJ_DESCRIPTION = "This is my description";
    protected static final String TEST_WEBPROJ_DEFAULT_WEBAPP = "ROOT";
    protected static final boolean TEST_WEBPROJ_USE_AS_TEMPLATE = true;
    protected static final boolean TEST_WEBPROJ_DONT_USE_AS_TEMPLATE = false;
    protected static String USER_ADMIN;
    protected static final String TEST_USER;
    protected static final String USER_ONE;
    protected static final String USER_TWO;
    protected static final String USER_THREE;
    protected static final String USER_FOUR;
    protected WebProjectService wpService;
    protected SandboxService sbService;
    protected AssetService assetService;
    protected MutableAuthenticationService authenticationService;
    protected PersonService personService;
    protected TransactionService transactionService;
    protected AVMLockingService avmLockingService;

    protected void setUp() throws Exception {
        this.wpService = (WebProjectService)ctx.getBean("WebProjectService");
        this.sbService = (SandboxService)ctx.getBean("SandboxService");
        this.assetService = (AssetService)ctx.getBean("AssetService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.avmLockingService = (AVMLockingService)ctx.getBean("AVMLockingService");
        USER_ADMIN = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ADMIN);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUsersCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AbstractWCMServiceImplTest.this.createUser(USER_ONE);
                AbstractWCMServiceImplTest.this.createUser(USER_TWO);
                AbstractWCMServiceImplTest.this.createUser(USER_THREE);
                AbstractWCMServiceImplTest.this.createUser(USER_FOUR);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(createUsersCallback);
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        List<WebProjectInfo> webProjects = this.wpService.listWebProjects();
        for (final WebProjectInfo wpInfo : webProjects) {
            if (!wpInfo.getStoreId().startsWith(TEST_WEBPROJ_DNS)) continue;
            RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteWebProjectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    AbstractWCMServiceImplTest.this.wpService.deleteWebProject(wpInfo.getNodeRef());
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteWebProjectWork);
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteUsersCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AbstractWCMServiceImplTest.this.deleteUser(USER_ONE);
                AbstractWCMServiceImplTest.this.deleteUser(USER_TWO);
                AbstractWCMServiceImplTest.this.deleteUser(USER_THREE);
                AbstractWCMServiceImplTest.this.deleteUser(USER_FOUR);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteUsersCallback);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    protected void deleteUser(String userName) {
        this.personService.deletePerson(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int pollForSnapshotCount(String stagingStoreId, int expectedCnt) throws InterruptedException {
        long start = System.currentTimeMillis();
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        int attempts = 0;
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            int cnt = 0;
            while (cnt != expectedCnt) {
                Thread.sleep(1500L);
                cnt = this.sbService.listSnapshots(stagingStoreId, false).size();
                if (++attempts == 1 && cnt > expectedCnt) break;
                if (attempts <= 200) continue;
                logger.error((Object)("Too many poll attempts: \n   Store:    " + stagingStoreId + "\n" + "   Time:     " + (System.currentTimeMillis() - start) + "ms\n" + "   Attempts: " + attempts));
                break;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            AuthenticationUtil.setFullyAuthenticatedUser((String)currentUser);
            throw throwable;
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)currentUser);
        logger.debug((Object)("pollForSnapshotCount: " + stagingStoreId + " in " + (System.currentTimeMillis() - start) + " msecs (" + attempts + " attempts)"));
        return attempts;
    }

    static {
        TEST_USER = "testWebUser-" + TEST_RUN;
        USER_ONE = TEST_USER + "-One";
        USER_TWO = TEST_USER + "-Two";
        USER_THREE = TEST_USER + "-Three";
        USER_FOUR = TEST_USER + "-Four";
    }
}

