/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;

public class WCMAspectTest
extends AbstractWCMServiceImplTest {
    private AssetService assetService = null;
    private WebProjectService wpService = null;
    private SandboxService sbService = null;
    private DictionaryDAO dictionaryDAO = null;
    private static final int SIZE = 1000;
    private static final String ADMIN = "admin";
    private static String TEST_TYPE_NAMESPACE = "http://www.alfresco.org/model/testaspectmodel/1.0";
    private static QName TEST_ASPECT_QNAME = QName.createQName((String)TEST_TYPE_NAMESPACE, (String)"Aspect");
    private static QName PROP_QNAME = QName.createQName((String)TEST_TYPE_NAMESPACE, (String)"applications");

    protected void setUp() throws Exception {
        super.setUp();
        this.wpService = (WebProjectService)ctx.getBean("WebProjectService");
        this.sbService = (SandboxService)ctx.getBean("SandboxService");
        this.assetService = (AssetService)ctx.getBean("AssetService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAspect() throws Exception {
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN);
            WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-aspectSimple", TEST_WEBPROJ_NAME + "-aspectSimple", "This is my title", "This is my description", "ROOT", false, null);
            String wpStoreId = wpInfo.getStoreId();
            String defaultWebApp = wpInfo.getDefaultWebApp();
            SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
            String authorSandboxId = sbInfo.getSandboxId();
            String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
            this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile", null);
            AssetInfo assetInfo = this.assetService.getAsset(authorSandboxId, authorSandboxPath + "/" + "myFile");
            this.attachAspect(assetInfo);
            this.checkAspect(assetInfo);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void checkAspect(AssetInfo assetInfo) {
        WCMAspectTest.assertTrue((boolean)this.assetService.hasAspect(assetInfo, TEST_ASPECT_QNAME));
        Map<QName, Serializable> properties = this.assetService.getAssetProperties(assetInfo);
        List list = (List)((Object)properties.get(PROP_QNAME));
        WCMAspectTest.assertEquals((int)list.size(), (int)1000);
    }

    private void attachAspect(final AssetInfo assetInfo) {
        M2Model model = M2Model.createModel((String)"custom:custom");
        model.createNamespace(TEST_TYPE_NAMESPACE, "custom");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Aspect testMandatoryAspect = model.createAspect("custom:" + TEST_ASPECT_QNAME.getLocalName());
        M2Property prop = testMandatoryAspect.createProperty("custom:" + PROP_QNAME.getLocalName());
        prop.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop.setMultiValued(true);
        prop.setIndexed(true);
        this.dictionaryDAO.putModel(model);
        final HashMap<QName, Serializable> aspectValues = new HashMap<QName, Serializable>();
        ArrayList<String> applications = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            applications.add("Adding " + i);
        }
        aspectValues.put(PROP_QNAME, applications);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                WCMAspectTest.this.assetService.addAspect(assetInfo, TEST_ASPECT_QNAME, aspectValues);
                return null;
            }
        });
    }
}

