/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encoding;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.alfresco.encoding.AbstractCharactersetFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;

public class TikaCharsetFinder
extends AbstractCharactersetFinder {
    private static Log logger = LogFactory.getLog(TikaCharsetFinder.class);
    private int threshold = 35;

    protected Charset detectCharsetImpl(byte[] buffer) throws Exception {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(buffer);
        CharsetMatch match = detector.detect();
        if (match != null && match.getConfidence() > this.threshold) {
            try {
                return Charset.forName(match.getName());
            }
            catch (UnsupportedCharsetException e) {
                logger.info((Object)("Charset detected as " + match.getName() + " but the JVM does not support this, detection skipped"));
            }
        }
        return null;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        if (threshold < 0) {
            threshold = 0;
        }
        if (threshold > 100) {
            threshold = 100;
        }
        this.threshold = threshold;
    }
}

