/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISAbstractDictionaryService
extends AbstractLifecycleBean
implements CMISDictionaryService,
DictionaryListener {
    protected static final Log logger = LogFactory.getLog(CMISAbstractDictionaryService.class);
    private DictionaryDAO dictionaryDAO;
    protected DictionaryService dictionaryService;
    protected TenantService tenantService;
    protected CMISMapping cmisMapping;
    protected PropertyAccessorMapping accessorMapping;
    protected PropertyLuceneBuilderMapping luceneBuilderMapping;
    private Map<String, DictionaryRegistry> registryMap = new ConcurrentHashMap<String, DictionaryRegistry>(4);

    public void setCmisMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setPropertyAccessorMapping(PropertyAccessorMapping accessorMapping) {
        this.accessorMapping = accessorMapping;
    }

    public void setPropertyLuceneBuilderMapping(PropertyLuceneBuilderMapping luceneBuilderMapping) {
        this.luceneBuilderMapping = luceneBuilderMapping;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    private DictionaryRegistry getRegistry() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        DictionaryRegistry registry = this.registryMap.get(tenantDomain);
        if (registry == null) {
            this.init();
            registry = this.registryMap.get(tenantDomain);
        }
        return registry;
    }

    @Override
    public TypeDefinitionWrapper findType(String typeId) {
        return this.getRegistry().typeDefsByTypeId.get(typeId);
    }

    @Override
    public TypeDefinitionWrapper findTypeForClass(QName clazz, BaseTypeId ... matchingScopes) {
        TypeDefinitionWrapper matchingTypeDef;
        boolean scopeByRelationship = false;
        for (BaseTypeId scope : matchingScopes) {
            if (scope != BaseTypeId.CMIS_RELATIONSHIP) continue;
            scopeByRelationship = true;
            break;
        }
        clazz = this.cmisMapping.getCmisType(clazz);
        TypeDefinitionWrapper typeDef = null;
        if (scopeByRelationship) {
            typeDef = this.getRegistry().assocDefsByQName.get(clazz);
        } else {
            typeDef = this.getRegistry().typeDefsByQName.get(clazz);
            if (typeDef == null) {
                typeDef = this.getRegistry().assocDefsByQName.get(clazz);
            }
        }
        TypeDefinitionWrapper typeDefinitionWrapper = matchingTypeDef = matchingScopes.length == 0 ? typeDef : null;
        if (typeDef != null) {
            for (BaseTypeId scope : matchingScopes) {
                if (typeDef.getBaseTypeId() != scope) continue;
                matchingTypeDef = typeDef;
                break;
            }
        }
        return matchingTypeDef;
    }

    @Override
    public TypeDefinitionWrapper findNodeType(QName clazz) {
        return this.getRegistry().typeDefsByQName.get(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findAssocType(QName clazz) {
        return this.getRegistry().assocDefsByQName.get(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findTypeByQueryName(String queryName) {
        return this.getRegistry().typeDefsByQueryName.get(queryName);
    }

    public QName getAlfrescoClass(QName name) {
        return this.cmisMapping.getAlfrescoClass(name);
    }

    @Override
    public PropertyDefinitionWrapper findProperty(String propId) {
        return this.getRegistry().propDefbyPropId.get(propId);
    }

    @Override
    public PropertyDefinitionWrapper findPropertyByQueryName(String queryName) {
        return this.getRegistry().propDefbyQueryName.get(queryName);
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes() {
        return Collections.unmodifiableList(this.getRegistry().baseTypes);
    }

    @Override
    public List<TypeDefinitionWrapper> getAllTypes() {
        return Collections.unmodifiableList(new ArrayList<AbstractTypeDefinitionWrapper>(this.getRegistry().typeDefsByTypeId.values()));
    }

    @Override
    public PropertyType findDataType(QName dataType) {
        return this.cmisMapping.getDataType(dataType);
    }

    @Override
    public QName findAlfrescoDataType(PropertyType propertyType) {
        return this.cmisMapping.getAlfrescoDataType(propertyType);
    }

    protected abstract void createDefinitions(DictionaryRegistry var1);

    private void init() {
        DictionaryRegistry registry = new DictionaryRegistry();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating type definitions...");
        }
        this.createDefinitions(registry);
        for (AbstractTypeDefinitionWrapper objectTypeDef : registry.typeDefsByTypeId.values()) {
            objectTypeDef.connectParentAndSubTypes(this.cmisMapping, registry, this.dictionaryService);
        }
        for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
            if (typeDef.getTypeDefinition(false).getParentTypeId() != null) continue;
            registry.baseTypes.add(typeDef);
            typeDef.resolveInheritance(this.cmisMapping, registry, this.dictionaryService);
        }
        for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
            registry.registerPropertyDefinitions(typeDef);
        }
        for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
            typeDef.assertComplete();
        }
        this.registryMap.put(this.tenantService.getCurrentUserDomain(), registry);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Initialized CMIS Dictionary. Types:" + registry.typeDefsByTypeId.size() + ", Base Types:" + registry.baseTypes.size()));
        }
    }

    @Override
    public void onDictionaryInit() {
    }

    @Override
    public void afterDictionaryInit() {
        this.init();
    }

    @Override
    public void afterDictionaryDestroy() {
        this.registryMap.remove(this.tenantService.getCurrentUserDomain());
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.afterDictionaryInit();
        this.dictionaryDAO.register(this);
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    class DictionaryRegistry {
        Map<QName, TypeDefinitionWrapper> typeDefsByQName = new HashMap<QName, TypeDefinitionWrapper>();
        Map<QName, TypeDefinitionWrapper> assocDefsByQName = new HashMap<QName, TypeDefinitionWrapper>();
        Map<String, AbstractTypeDefinitionWrapper> typeDefsByTypeId = new HashMap<String, AbstractTypeDefinitionWrapper>();
        Map<String, TypeDefinitionWrapper> typeDefsByQueryName = new HashMap<String, TypeDefinitionWrapper>();
        List<TypeDefinitionWrapper> baseTypes = new ArrayList<TypeDefinitionWrapper>();
        Map<String, PropertyDefinitionWrapper> propDefbyPropId = new HashMap<String, PropertyDefinitionWrapper>();
        Map<String, PropertyDefinitionWrapper> propDefbyQueryName = new HashMap<String, PropertyDefinitionWrapper>();

        DictionaryRegistry() {
        }

        public void registerTypeDefinition(AbstractTypeDefinitionWrapper typeDef) {
            AbstractTypeDefinitionWrapper existingTypeDef = this.typeDefsByTypeId.get(typeDef.getTypeId());
            if (existingTypeDef != null) {
                throw new AlfrescoRuntimeException("Type " + typeDef.getTypeId() + " already registered");
            }
            this.typeDefsByTypeId.put(typeDef.getTypeId(), typeDef);
            QName typeQName = typeDef.getAlfrescoName();
            if (typeQName != null) {
                if (typeDef instanceof RelationshipTypeDefintionWrapper && !typeDef.isBaseType()) {
                    this.assocDefsByQName.put(typeQName, typeDef);
                } else {
                    this.typeDefsByQName.put(typeQName, typeDef);
                }
            }
            this.typeDefsByQueryName.put(typeDef.getTypeDefinition(false).getQueryName(), typeDef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered type " + typeDef.getTypeId() + " (scope=" + typeDef.getBaseTypeId() + ")"));
                logger.debug((Object)(" QName: " + typeDef.getAlfrescoName()));
                logger.debug((Object)(" Table: " + typeDef.getTypeDefinition(false).getQueryName()));
                logger.debug((Object)(" Action Evaluators: " + typeDef.getActionEvaluators().size()));
            }
        }

        public void registerPropertyDefinitions(AbstractTypeDefinitionWrapper typeDef) {
            for (PropertyDefinitionWrapper propDef : typeDef.getProperties()) {
                if (propDef.getPropertyDefinition().isInherited().booleanValue()) continue;
                this.propDefbyPropId.put(propDef.getPropertyId(), propDef);
                this.propDefbyQueryName.put(propDef.getPropertyDefinition().getQueryName(), propDef);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DictionaryRegistry[");
            builder.append("Types=").append(this.typeDefsByTypeId.size()).append(", ");
            builder.append("Base Types=").append(this.baseTypes.size()).append(", ");
            builder.append("]");
            return builder.toString();
        }
    }
}

