/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.dictionary.DelegateModelQuery;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2AspectDefinition;
import org.alfresco.repo.dictionary.M2ClassDefinition;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2DataTypeDefinition;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDefinition;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.M2TypeDefinition;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledModel
implements ModelQuery {
    private static final Log logger = LogFactory.getLog(DictionaryDAOImpl.class);
    private M2Model model;
    private ModelDefinition modelDefinition;
    private Map<QName, DataTypeDefinition> dataTypes = new HashMap<QName, DataTypeDefinition>();
    private Map<QName, ClassDefinition> classes = new HashMap<QName, ClassDefinition>();
    private Map<QName, TypeDefinition> types = new HashMap<QName, TypeDefinition>();
    private Map<QName, AspectDefinition> aspects = new HashMap<QName, AspectDefinition>();
    private Map<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
    private Map<QName, AssociationDefinition> associations = new HashMap<QName, AssociationDefinition>();
    private Map<QName, ConstraintDefinition> constraints = new HashMap<QName, ConstraintDefinition>();

    CompiledModel(M2Model model, DictionaryDAO dictionaryDAO, NamespaceDAO namespaceDAO, boolean enableConstraintClassLoading) {
        try {
            this.model = model;
            this.constructDefinitions(model, namespaceDAO, dictionaryDAO);
            DelegateModelQuery query = new DelegateModelQuery(this, dictionaryDAO);
            this.resolveDependencies(query, namespaceDAO);
            NamespacePrefixResolver localPrefixes = this.createLocalPrefixResolver(model, namespaceDAO);
            this.resolveInheritance(query, localPrefixes, this.constraints);
            for (ConstraintDefinition def : this.constraints.values()) {
                ((M2ConstraintDefinition)def).resolveDependencies(query, enableConstraintClassLoading);
            }
        }
        catch (Exception e) {
            throw new DictionaryException("Failed to compile model " + model.getName(), e);
        }
    }

    public M2Model getM2Model() {
        return this.model;
    }

    private void constructDefinitions(M2Model model, NamespaceDAO namespaceDAO, DictionaryDAO dictionaryDAO) {
        Object def;
        NamespacePrefixResolver localPrefixes = this.createLocalPrefixResolver(model, namespaceDAO);
        this.modelDefinition = new M2ModelDefinition(model, localPrefixes, dictionaryDAO);
        for (M2DataType propType : model.getPropertyTypes()) {
            def = new M2DataTypeDefinition(this.modelDefinition, propType, localPrefixes);
            if (this.dataTypes.containsKey(((M2DataTypeDefinition)def).getName())) {
                throw new DictionaryException("Found duplicate property type definition " + propType.getName());
            }
            this.dataTypes.put(((M2DataTypeDefinition)def).getName(), (DataTypeDefinition)def);
        }
        for (M2Type type : model.getTypes()) {
            def = new M2TypeDefinition(this.modelDefinition, type, localPrefixes, this.properties, this.associations);
            if (this.classes.containsKey(((M2ClassDefinition)def).getName())) {
                throw new DictionaryException("Found duplicate class definition " + type.getName() + " (a type)");
            }
            this.classes.put(((M2ClassDefinition)def).getName(), (ClassDefinition)def);
            this.types.put(((M2ClassDefinition)def).getName(), (TypeDefinition)def);
        }
        for (M2Aspect aspect : model.getAspects()) {
            def = new M2AspectDefinition(this.modelDefinition, aspect, localPrefixes, this.properties, this.associations);
            if (this.classes.containsKey(((M2ClassDefinition)def).getName())) {
                throw new DictionaryException("Found duplicate class definition " + aspect.getName() + " (an aspect)");
            }
            this.classes.put(((M2ClassDefinition)def).getName(), (ClassDefinition)def);
            this.aspects.put(((M2ClassDefinition)def).getName(), (AspectDefinition)def);
        }
        for (M2Constraint constraint : model.getConstraints()) {
            def = new M2ConstraintDefinition(this.modelDefinition, null, constraint, localPrefixes);
            QName qname = ((M2ConstraintDefinition)def).getName();
            if (this.constraints.containsKey(qname)) {
                throw new DictionaryException("Found duplicate constraint definition " + constraint.getName() + " (an aspect)");
            }
            this.constraints.put(qname, (ConstraintDefinition)def);
        }
    }

    private NamespacePrefixResolver createLocalPrefixResolver(M2Model model, NamespaceDAO namespaceDAO) {
        Collection<String> uris = namespaceDAO.getURIs();
        DynamicNamespacePrefixResolver prefixResolver = new DynamicNamespacePrefixResolver(null);
        for (M2Namespace imported : model.getImports()) {
            String uri = imported.getUri();
            if (!uris.contains(uri)) {
                throw new NamespaceException("URI " + uri + " cannot be imported as it is not defined (with prefix " + imported.getPrefix());
            }
            prefixResolver.registerNamespace(imported.getPrefix(), uri);
        }
        for (M2Namespace defined : model.getNamespaces()) {
            prefixResolver.registerNamespace(defined.getPrefix(), defined.getUri());
        }
        return prefixResolver;
    }

    private void resolveDependencies(ModelQuery query, NamespaceDAO namespaceDAO) {
        NamespacePrefixResolver prefixResolver = this.createLocalPrefixResolver(this.model, namespaceDAO);
        for (DataTypeDefinition dataTypeDefinition : this.dataTypes.values()) {
            ((M2DataTypeDefinition)dataTypeDefinition).resolveDependencies(query);
        }
        for (ClassDefinition classDefinition : this.classes.values()) {
            ((M2ClassDefinition)classDefinition).resolveDependencies(query, prefixResolver, this.constraints);
        }
    }

    private void resolveInheritance(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        TreeMap<Integer, ArrayList<ClassDefinition>> order = new TreeMap<Integer, ArrayList<ClassDefinition>>();
        for (ClassDefinition def : this.classes.values()) {
            ClassDefinition parentClass;
            int depth = 0;
            QName parentName = def.getParentName();
            while (parentName != null && (parentClass = this.getClass(parentName)) != null) {
                ++depth;
                parentName = parentClass.getParentName();
            }
            ArrayList<ClassDefinition> classes = (ArrayList<ClassDefinition>)order.get(depth);
            if (classes == null) {
                classes = new ArrayList<ClassDefinition>();
                order.put(depth, classes);
            }
            classes.add(def);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Resolving inheritance: class " + def.getName() + " found at depth " + depth));
        }
        for (int depth = 0; depth < order.size(); ++depth) {
            for (ClassDefinition def : (List)order.get(depth)) {
                ((M2ClassDefinition)def).resolveInheritance(query, prefixResolver, modelConstraints);
            }
        }
    }

    public ModelDefinition getModelDefinition() {
        return this.modelDefinition;
    }

    public Collection<DataTypeDefinition> getDataTypes() {
        return this.dataTypes.values();
    }

    public Collection<TypeDefinition> getTypes() {
        return this.types.values();
    }

    public Collection<AspectDefinition> getAspects() {
        return this.aspects.values();
    }

    public Collection<PropertyDefinition> getProperties() {
        return this.properties.values();
    }

    @Override
    public DataTypeDefinition getDataType(QName name) {
        return this.dataTypes.get(name);
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        for (DataTypeDefinition dataTypeDef : this.dataTypes.values()) {
            if (!dataTypeDef.getJavaClassName().equals(javaClass.getName())) continue;
            return dataTypeDef;
        }
        return null;
    }

    @Override
    public TypeDefinition getType(QName name) {
        return this.types.get(name);
    }

    @Override
    public AspectDefinition getAspect(QName name) {
        return this.aspects.get(name);
    }

    @Override
    public ClassDefinition getClass(QName name) {
        return this.classes.get(name);
    }

    @Override
    public PropertyDefinition getProperty(QName name) {
        return this.properties.get(name);
    }

    @Override
    public AssociationDefinition getAssociation(QName name) {
        return this.associations.get(name);
    }

    public Collection<AssociationDefinition> getAssociations() {
        return this.associations.values();
    }

    public Collection<ConstraintDefinition> getConstraints() {
        return this.constraints.values();
    }

    @Override
    public ConstraintDefinition getConstraint(QName name) {
        return this.constraints.get(name);
    }
}

