/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hibernate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.alfresco.hibernate.DialectFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectFactoryBean
implements FactoryBean<Dialect> {
    private LocalSessionFactoryBean localSessionFactory;

    public void setLocalSessionFactory(LocalSessionFactoryBean localSessionFactory) {
        this.localSessionFactory = localSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialect getObject() throws SQLException {
        Session session = this.localSessionFactory.getObject().openSession();
        Configuration cfg = this.localSessionFactory.getConfiguration();
        Connection con = null;
        try {
            con = session.connection();
            con.setAutoCommit(true);
            DatabaseMetaData meta = con.getMetaData();
            Dialect dialect = DialectFactory.buildDialect(cfg.getProperties(), meta.getDatabaseProductName(), meta.getDatabaseMajorVersion());
            Dialect dialect2 = dialect = this.changeDialect(cfg, dialect);
            return dialect2;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    private Dialect changeDialect(Configuration cfg, Dialect dialect) {
        String dialectName = cfg.getProperty("hibernate.dialect");
        if (dialectName == null || dialectName.length() == 0) {
            cfg.setProperty("hibernate.dialect", dialect.getClass().getName());
        }
        return dialect;
    }

    public Class<?> getObjectType() {
        return Dialect.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

