/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.httpclient.Response;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class HttpMethodResponse
implements Response {
    protected HttpMethod method;

    public HttpMethodResponse(HttpMethod method) throws IOException {
        this.method = method;
    }

    public void release() {
        this.method.releaseConnection();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getHeader(String name) {
        Header header = this.method.getResponseHeader(name);
        return header != null ? header.getValue() : null;
    }

    public int getStatus() {
        return this.method.getStatusCode();
    }
}

