/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.net.URL;

public class Debug {
    public static String whichClass(String className) throws ClassNotFoundException {
        String path = className;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        path = path.replace('.', '/');
        URL url = Debug.class.getResource(path = path + ".class");
        if (url == null) {
            throw new ClassNotFoundException(className);
        }
        String location = url.toExternalForm();
        if (location.startsWith("jar")) {
            location = location.substring(10, location.lastIndexOf("!"));
        } else if (location.startsWith("file:")) {
            location = location.substring(6);
        }
        return location;
    }

    public static String whichClassLoader(String className) throws ClassNotFoundException {
        String result = "Could not determine class loader for " + className;
        Class<?> clazz = Class.forName(className);
        ClassLoader loader = clazz.getClassLoader();
        if (loader != null) {
            result = clazz.getClassLoader().toString();
        }
        return result;
    }

    public static String whichClassLoaderHierarchy(String className) throws ClassNotFoundException {
        StringBuffer buffer = new StringBuffer();
        Class<?> clazz = Class.forName(className);
        ClassLoader loader = clazz.getClassLoader();
        if (loader != null) {
            buffer.append(loader.toString());
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                buffer.append("\n-> ").append(parent.toString());
            }
        } else {
            buffer.append("Could not determine class loader for " + className);
        }
        return buffer.toString();
    }
}

