/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionNumber
implements Comparable<VersionNumber>,
Serializable {
    private static final long serialVersionUID = -1570247769786810251L;
    public static final VersionNumber VERSION_ZERO = new VersionNumber("0");
    public static final VersionNumber VERSION_BIG = new VersionNumber("999");
    private static final String DELIMITER = "\\.";
    private final int[] parts;

    public VersionNumber(String version) {
        String[] versions = version.split(DELIMITER);
        if (versions.length < 1) {
            throw new AlfrescoRuntimeException("The version string '" + version + "' is invalid.");
        }
        try {
            int index = 0;
            this.parts = new int[versions.length];
            for (String versionPart : versions) {
                int part;
                this.parts[index] = part = Integer.parseInt(versionPart);
                ++index;
            }
        }
        catch (NumberFormatException e) {
            throw new AlfrescoRuntimeException("The version string '" + version + "' is invalid.");
        }
    }

    public int[] getParts() {
        return (int[])this.parts.clone();
    }

    @Override
    public int compareTo(VersionNumber obj) {
        int result = 0;
        VersionNumber that = obj;
        int length = 0;
        length = this.parts.length > that.parts.length ? this.parts.length : that.parts.length;
        for (int index = 0; index < length; ++index) {
            int thatPart;
            int thisPart = this.getPart(index);
            if (thisPart > (thatPart = that.getPart(index))) {
                result = 1;
                break;
            }
            if (thisPart >= thatPart) continue;
            result = -1;
            break;
        }
        return result;
    }

    public int getPart(int index) {
        int result = 0;
        if (index < this.parts.length) {
            result = this.parts[index];
        }
        return result;
    }

    public int hashCode() {
        if (this.parts == null || this.parts.length == 0) {
            return 0;
        }
        if (this.parts.length >= 2) {
            return this.parts[0] * 17 + this.parts[1];
        }
        return this.parts[0];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionNumber)) {
            return false;
        }
        VersionNumber that = (VersionNumber)obj;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int part : this.parts) {
            if (!first) {
                sb.append(".");
            }
            first = false;
            sb.append(part);
        }
        return sb.toString();
    }
}

