/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.VersionNumber;

public class VersionNumberTest
extends TestCase {
    public void testCreate() {
        VersionNumber version1 = new VersionNumber("1");
        int[] parts1 = version1.getParts();
        VersionNumberTest.assertNotNull((Object)parts1);
        VersionNumberTest.assertEquals((int)1, (int)parts1.length);
        VersionNumberTest.assertEquals((int)1, (int)parts1[0]);
        VersionNumber version2 = new VersionNumber("1.2");
        int[] parts2 = version2.getParts();
        VersionNumberTest.assertNotNull((Object)parts2);
        VersionNumberTest.assertEquals((int)2, (int)parts2.length);
        VersionNumberTest.assertEquals((int)1, (int)parts2[0]);
        VersionNumberTest.assertEquals((int)2, (int)parts2[1]);
        VersionNumber version3 = new VersionNumber("1.2.3");
        int[] parts3 = version3.getParts();
        VersionNumberTest.assertNotNull((Object)parts3);
        VersionNumberTest.assertEquals((int)3, (int)parts3.length);
        VersionNumberTest.assertEquals((int)1, (int)parts3[0]);
        VersionNumberTest.assertEquals((int)2, (int)parts3[1]);
        VersionNumberTest.assertEquals((int)3, (int)parts3[2]);
        try {
            new VersionNumber("xxx");
            VersionNumberTest.fail((String)"Should not have created an invalid version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new VersionNumber("1-1-2");
            VersionNumberTest.fail((String)"Should not have created an invalid version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new VersionNumber("1.2.3a");
            VersionNumberTest.fail((String)"Should not have created an invalid version");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testEquals() {
        VersionNumber version0 = new VersionNumber("1");
        VersionNumber version1 = new VersionNumber("1.2");
        VersionNumber version2 = new VersionNumber("1.2");
        VersionNumber version3 = new VersionNumber("1.2.3");
        VersionNumber version4 = new VersionNumber("1.2.3");
        VersionNumber version5 = new VersionNumber("1.3.3");
        VersionNumber version6 = new VersionNumber("1.0");
        VersionNumberTest.assertFalse((boolean)version0.equals(version1));
        VersionNumberTest.assertTrue((boolean)version1.equals(version2));
        VersionNumberTest.assertFalse((boolean)version2.equals(version3));
        VersionNumberTest.assertTrue((boolean)version3.equals(version4));
        VersionNumberTest.assertFalse((boolean)version4.equals(version5));
        VersionNumberTest.assertTrue((boolean)version0.equals(version6));
    }

    public void testCompare() {
        VersionNumber version0 = new VersionNumber("1");
        VersionNumber version1 = new VersionNumber("1.2");
        VersionNumber version2 = new VersionNumber("1.2");
        VersionNumber version3 = new VersionNumber("1.2.3");
        VersionNumber version4 = new VersionNumber("1.11");
        VersionNumber version5 = new VersionNumber("1.3.3");
        VersionNumber version6 = new VersionNumber("2.0");
        VersionNumber version7 = new VersionNumber("2.0.1");
        VersionNumber version8 = new VersionNumber("10.0");
        VersionNumber version9 = new VersionNumber("10.3");
        VersionNumber version10 = new VersionNumber("11.1");
        VersionNumberTest.assertEquals((int)-1, (int)version0.compareTo(version1));
        VersionNumberTest.assertEquals((int)1, (int)version1.compareTo(version0));
        VersionNumberTest.assertEquals((int)0, (int)version1.compareTo(version2));
        VersionNumberTest.assertEquals((int)-1, (int)version2.compareTo(version3));
        VersionNumberTest.assertEquals((int)-1, (int)version2.compareTo(version4));
        VersionNumberTest.assertEquals((int)-1, (int)version3.compareTo(version5));
        VersionNumberTest.assertEquals((int)1, (int)version6.compareTo(version5));
        VersionNumberTest.assertEquals((int)-1, (int)version6.compareTo(version7));
        VersionNumberTest.assertEquals((int)-1, (int)version1.compareTo(version8));
        VersionNumberTest.assertEquals((int)-1, (int)version8.compareTo(version9));
        VersionNumberTest.assertEquals((int)-1, (int)version9.compareTo(version10));
    }
}

