/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    public static <F, T> List<T> transform(JSONArray values, Function<F, ? extends T> transformer) {
        if (values == null || values.length() < 1) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>(values.length());
        for (int i = 0; i < values.length(); ++i) {
            T result = transformer.apply(values.opt(i));
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public static List<String> toListOfStrings(JSONArray values) {
        return JsonUtils.transform(values, CollectionUtils.TO_STRING_TRANSFORMER);
    }
}

