/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.ExtensibilityModelElement;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.impl.CloseModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.DefaultContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.DiscardUnboundContentModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityDebugData;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.extensibility.impl.OpenModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.UnboundContentModelElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibilityModelImpl
implements ExtensibilityModel {
    private static final Log logger = LogFactory.getLog(ExtensibilityModelImpl.class);
    private ExtensibilityModel parentModel = null;
    private HandlesExtensibility handler = null;
    private ExtensibilityDebugData debugData = new ExtensibilityDebugData();
    private ExtensibilityDebugData childDebugData = null;
    private ArrayList<ExtensibilityModelElement> modelContent = new ArrayList();
    private boolean modelStarted = false;
    private boolean extensionProcessing = false;
    private ModelWriter modelWriter = new ModelWriter();
    private Stack<ExtensibilityDirectiveData> directiveStack = new Stack();

    @Override
    public ExtensibilityModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public ExtensibilityDebugData getDebugData() {
        return this.debugData;
    }

    @Override
    public ExtensibilityDebugData getChildDebugData() {
        return this.childDebugData;
    }

    @Override
    public void setChildDebugData(ExtensibilityDebugData childData) {
        this.childDebugData = childData;
    }

    public ExtensibilityModelImpl(ExtensibilityModel parentModel, HandlesExtensibility handler) {
        this.parentModel = parentModel;
        this.handler = handler;
    }

    @Override
    public boolean isModelStarted() {
        return this.modelStarted;
    }

    @Override
    public ModelWriter getWriter() {
        return this.modelWriter;
    }

    @Override
    public void switchToExtensionProcessing() {
        this.extensionProcessing = true;
        this.addDiscardContent();
    }

    @Override
    public boolean isExtensionProcessing() {
        return this.extensionProcessing;
    }

    private void pushDirective(ExtensibilityDirectiveData directive) {
        this.pushDirective(directive, this.modelContent);
    }

    private void pushDirective(ExtensibilityDirectiveData directive, List<ExtensibilityModelElement> model) {
        this.directiveStack.push(directive);
        model.add(directive.createOpen());
        ContentModelElement contentElement = directive.createContentModelElement();
        model.add(contentElement);
        this.debugData.addData(contentElement.getId(), contentElement.getDirectiveName(), this.handler.getFileBeingProcessed());
        this.modelWriter.setCurrentBufferElement(contentElement.getNextContentBufferElement());
    }

    private ExtensibilityDirectiveData popDirective() {
        return this.popDirective(this.modelContent);
    }

    private ExtensibilityDirectiveData popDirective(List<ExtensibilityModelElement> model) {
        ExtensibilityDirectiveData currentDirective = this.directiveStack.pop();
        model.add(currentDirective.createClose());
        if (this.directiveStack.isEmpty()) {
            if (this.extensionProcessing) {
                this.addDiscardContent();
            } else {
                this.addUnboundContent();
            }
        } else {
            ExtensibilityDirectiveData lastDirective = this.directiveStack.peek();
            ContentModelElement contentElement = lastDirective.createContentModelElement();
            model.add(contentElement);
            this.modelWriter.setCurrentBufferElement(contentElement.getNextContentBufferElement());
        }
        return currentDirective;
    }

    @Override
    public void addUnboundContent() {
        this.modelStarted = true;
        UnboundContentModelElementImpl unboundContent = new UnboundContentModelElementImpl();
        this.modelContent.add(unboundContent);
        this.modelWriter.setCurrentBufferElement(unboundContent.getNextContentBufferElement());
    }

    @Override
    public void addDiscardContent() {
        this.modelStarted = true;
        DiscardUnboundContentModelElementImpl discardContent = new DiscardUnboundContentModelElementImpl();
        this.modelContent.add(discardContent);
        this.modelWriter.setCurrentBufferElement(discardContent.getNextContentBufferElement());
    }

    @Override
    public void flushModel(Writer out) {
        Writer targetWriter = out;
        if (this.parentModel != null) {
            targetWriter = this.parentModel.getWriter();
        }
        for (ExtensibilityModelElement element : this.modelContent) {
            if (!(element instanceof ContentModelElement)) continue;
            ContentModelElement cme = (ContentModelElement)element;
            try {
                targetWriter.write(cme.flushContent());
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error((Object)("The following exception occurred flushing the model for ContentModelElement: " + cme), (Throwable)e);
            }
        }
        this.directiveStack.clear();
        this.modelContent.clear();
        this.modelStarted = false;
    }

    @Override
    public void merge(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.modelStarted = true;
        if (!this.extensionProcessing) {
            this.pushDirective(directiveData);
            directiveData.render(this.modelWriter);
            this.popDirective();
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The merge operation was attempted to be used in an extension by directive: " + directiveData));
        }
    }

    private List<ExtensibilityModelElement> generateAdditionalContent(ExtensibilityDirectiveData directive) throws TemplateException, IOException {
        ArrayList<ExtensibilityModelElement> additionalElements = new ArrayList<ExtensibilityModelElement>();
        this.pushDirective(directive, additionalElements);
        directive.render(this.modelWriter);
        this.popDirective(additionalElements);
        return additionalElements;
    }

    @Override
    public void before(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                List<ExtensibilityModelElement> additionalElements = this.generateAdditionalContent(directiveData);
                this.modelContent.addAll(targetRange.getStartingIndex() - 1, additionalElements);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not locate target directive when processing 'before' action for directive: " + directiveData));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'before' action was attempted to used when defining the base model by directive:" + directiveData));
        }
    }

    @Override
    public void after(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                List<ExtensibilityModelElement> additionalElements = this.generateAdditionalContent(directiveData);
                this.modelContent.addAll(targetRange.getEndingIndex() + 1, additionalElements);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not locate target directive when processing 'after' action for directive: " + directiveData));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'after' action was attempted to used when defining the base model by directive:" + directiveData));
        }
    }

    @Override
    public void remove(ExtensibilityDirectiveData directiveData) {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find target " + directiveData.getTarget() + " to remove when processing directive: " + directiveData));
                }
            } else {
                targetRange.getTargetRange().clear();
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'remove' action was attempted to used when defining the base model by directive:" + directiveData));
        }
    }

    @Override
    public void replace(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                targetRange.getTargetRange().clear();
                ArrayList<ExtensibilityModelElement> replacingElements = new ArrayList<ExtensibilityModelElement>();
                this.pushDirective(directiveData, replacingElements);
                directiveData.render(this.modelWriter);
                this.popDirective(replacingElements);
                this.modelContent.addAll(targetRange.getStartingIndex(), replacingElements);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find target " + directiveData.getTarget() + " to replace when processing directive: " + directiveData));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'replace' action was attempted to used when defining the base model by directive:" + directiveData));
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringBuilder indent = new StringBuilder();
        for (ExtensibilityModelElement element : this.modelContent) {
            if (element.getType().equals("CLOSE")) {
                indent.delete(indent.length() - 4, indent.length());
            }
            out.append(indent + "<" + element.getType() + " id=\"" + element.getId() + "\">\n");
            if (!element.getType().equals("OPEN")) continue;
            indent.append("    ");
        }
        return out.toString();
    }

    @Override
    public ContentModelElement findContentModelElement(String id) {
        ContentModelElement target = null;
        DefaultContentModelElement matcher = new DefaultContentModelElement(id, null);
        int index = this.modelContent.indexOf(matcher);
        if (index != -1) {
            target = (ContentModelElement)this.modelContent.get(index);
        }
        return target;
    }

    private RangeData findTargetRange(String id, String directiveName) {
        RangeData results = null;
        List<ExtensibilityModelElement> targetRange = null;
        OpenModelElementImpl targetOpen = new OpenModelElementImpl(id, directiveName);
        int openIndex = this.modelContent.indexOf(targetOpen);
        if (openIndex == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find extensibiliy OPEN model element with the id: " + id));
            }
        } else {
            CloseModelElementImpl targetClose = new CloseModelElementImpl(id, null);
            int closeIndex = this.modelContent.indexOf(targetClose);
            if (closeIndex == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find extensibiliy CLOSE model element with the id: " + id));
                }
            } else if (closeIndex > openIndex) {
                targetRange = this.modelContent.subList(openIndex, closeIndex + 1);
                results = new RangeData(openIndex, closeIndex, targetRange);
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("An unexpected error occurred, the index of the CLOSE element is less that that of the associated OPEN element for target id: " + id));
            }
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RangeData {
        private int startingIndex = -1;
        private int endingIndex = -1;
        private List<ExtensibilityModelElement> targetRange = null;

        public RangeData(int startingIndex, int endingIndex, List<ExtensibilityModelElement> targetRange) {
            this.startingIndex = startingIndex;
            this.endingIndex = endingIndex;
            this.targetRange = targetRange;
        }

        public int getStartingIndex() {
            return this.startingIndex;
        }

        public int getEndingIndex() {
            return this.endingIndex;
        }

        public List<ExtensibilityModelElement> getTargetRange() {
            return this.targetRange;
        }
    }
}

