/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Map;
import org.springframework.extensions.webscripts.URLModel;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultURLModel
implements URLModel {
    private static final Map<String, String> emptyArgs = Collections.emptyMap();
    private final WebScriptRequest req;

    protected DefaultURLModel(WebScriptRequest req) {
        this.req = req;
    }

    @Override
    public String getServer() {
        return this.req.getServerPath();
    }

    @Override
    public String getContext() {
        return this.req.getContextPath();
    }

    @Override
    public String getServiceContext() {
        return this.req.getServiceContextPath();
    }

    @Override
    public String getService() {
        return this.req.getServicePath();
    }

    @Override
    public String getFull() {
        return this.req.getURL();
    }

    @Override
    public String getArgs() {
        String args = this.req.getQueryString();
        return args == null ? "" : args;
    }

    @Override
    public String getMatch() {
        return this.req.getServiceMatch().getPath();
    }

    @Override
    public String getExtension() {
        return this.req.getExtensionPath();
    }

    @Override
    public String getTemplate() {
        return this.req.getServiceMatch().getTemplate();
    }

    @Override
    public Map<String, String> getTemplateArgs() {
        Map<String, String> args = this.req.getServiceMatch().getTemplateVars();
        return args == null ? emptyArgs : args;
    }
}

