/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.FormatWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatRegistry {
    private static final Log logger = LogFactory.getLog(FormatRegistry.class);
    private Map<String, String> formats = new HashMap<String, String>();
    private Map<String, String> mimetypes = new HashMap<String, String>();
    private Map<String, Map<String, String>> agentFormats = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> agentMimetypes = new HashMap<String, Map<String, String>>();
    private Map<String, FormatReader<Object>> readers = new HashMap<String, FormatReader<Object>>();
    private FormatReader<Object> defaultReader;
    private Map<String, FormatWriter<Object>> writers = new HashMap<String, FormatWriter<Object>>();

    public void setDefaultReader(FormatReader<Object> defaultReader) {
        this.defaultReader = defaultReader;
    }

    public void addReader(FormatReader<Object> reader) {
        String mimetype = reader.getSourceMimetype();
        this.readers.put(reader.getSourceMimetype(), reader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered format reader: converts mimetype '" + mimetype + "' to class '" + reader.getDestinationClass().getSimpleName() + "'"));
        }
    }

    public void addWriter(FormatWriter<Object> writer) {
        String mimetype = writer.getDestinationMimetype();
        Class<Object> clazz = writer.getSourceClass();
        this.writers.put(clazz.getName() + "||" + mimetype, writer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered format writer: converts class '" + clazz.getSimpleName() + "' to mimetype '" + mimetype + "'"));
        }
    }

    public void addFormats(String agent, Map<String, String> formatsToAdd) {
        Map<String, String> formatsForAgent = this.formats;
        if (agent != null && (formatsForAgent = this.agentFormats.get(agent)) == null) {
            formatsForAgent = new HashMap<String, String>();
            this.agentFormats.put(agent, formatsForAgent);
        }
        for (Map.Entry<String, String> entry : formatsToAdd.entrySet()) {
            String val;
            if (logger.isWarnEnabled() && (val = formatsForAgent.get(entry.getKey())) != null) {
                logger.warn((Object)("Replacing mimetype '" + val + "' with '" + entry.getValue() + "' for format '" + entry.getKey() + "' (agent: " + agent + ")"));
            }
            formatsForAgent.put(entry.getKey(), entry.getValue());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Registered format '" + entry.getKey() + "' for mimetype '" + entry.getValue() + "' (agent: " + agent + ")"));
        }
    }

    public void addMimetypes(String agent, Map<String, String> mimetypesToAdd) {
        Map<String, String> mimetypesForAgent = this.mimetypes;
        if (agent != null && (mimetypesForAgent = this.agentMimetypes.get(agent)) == null) {
            mimetypesForAgent = new HashMap<String, String>();
            this.agentMimetypes.put(agent, mimetypesForAgent);
        }
        for (Map.Entry<String, String> entry : mimetypesToAdd.entrySet()) {
            String val;
            if (logger.isWarnEnabled() && (val = mimetypesForAgent.get(entry.getKey())) != null) {
                logger.warn((Object)("Replacing format '" + val + "' with '" + entry.getValue() + "' for mimetype '" + entry.getKey() + "' (agent: " + agent + ")"));
            }
            mimetypesForAgent.put(entry.getKey(), entry.getValue());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Registered mimetype '" + entry.getKey() + "' for format '" + entry.getValue() + "' (agent: " + agent + ")"));
        }
    }

    public String getMimeType(String agent, String format) {
        Map<String, String> formatsForAgent;
        String mimetype = null;
        if (agent != null && (formatsForAgent = this.agentFormats.get(agent)) != null) {
            mimetype = formatsForAgent.get(format);
        }
        if (mimetype == null) {
            mimetype = this.formats.get(format);
        }
        return mimetype;
    }

    public String getFormat(String agent, String mimetype) {
        Map<String, String> mimetypesForAgent;
        String format = null;
        if (agent != null && (mimetypesForAgent = this.agentMimetypes.get(agent)) != null) {
            format = mimetypesForAgent.get(mimetype);
        }
        if (format == null) {
            format = this.mimetypes.get(mimetype);
        }
        return format;
    }

    public FormatReader<Object> getReader(String mimetype) {
        if (mimetype == null) {
            return this.defaultReader;
        }
        String generalizedMimetype = mimetype;
        while (generalizedMimetype != null) {
            FormatReader<Object> reader = this.readers.get(generalizedMimetype);
            if (reader != null) {
                return reader;
            }
            generalizedMimetype = this.generalizeMimetype(generalizedMimetype);
        }
        return null;
    }

    public FormatWriter<Object> getWriter(Object object, String mimetype) {
        String generalizedMimetype = mimetype;
        while (generalizedMimetype != null) {
            FormatWriter<Object> writer = this.writers.get(object.getClass().getName() + "||" + generalizedMimetype);
            if (writer != null) {
                return writer;
            }
            generalizedMimetype = this.generalizeMimetype(generalizedMimetype);
        }
        return null;
    }

    public String generalizeMimetype(String mimetype) {
        int params;
        String generalizedMimetype = null;
        if (mimetype != null && (params = mimetype.lastIndexOf(";")) != -1) {
            generalizedMimetype = mimetype.substring(0, params);
        }
        return generalizedMimetype;
    }
}

