/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.UriIndex;
import org.springframework.extensions.webscripts.UriTemplate;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public class JaxRSUriIndex
implements UriIndex {
    private static final Log logger = LogFactory.getLog(JaxRSUriIndex.class);
    private Map<IndexEntry, IndexEntry> index = new TreeMap<IndexEntry, IndexEntry>(COMPARATOR);
    static final Comparator<IndexEntry> COMPARATOR = new Comparator<IndexEntry>(){

        @Override
        public int compare(IndexEntry o1, IndexEntry o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int i = o2.getTemplate().getStaticCharCount() - o1.getTemplate().getStaticCharCount();
            if (i != 0) {
                return i;
            }
            i = o2.getTemplate().getVariableNames().length - o1.getTemplate().getVariableNames().length;
            if (i != 0) {
                return i;
            }
            i = o2.getTemplate().getRegex().pattern().compareTo(o1.getTemplate().getRegex().pattern());
            if (i != 0) {
                return i;
            }
            return o2.method.compareTo(o1.method);
        }
    };

    public void clear() {
        this.index.clear();
    }

    public int getSize() {
        return this.index.size();
    }

    public Match findWebScript(String method, String uri) {
        IndexEntry pathMatch = null;
        Map<String, String> varsMatch = null;
        Match scriptMatch = null;
        String match = uri;
        String matchNoExt = uri;
        int extIdx = uri.indexOf(46);
        if (extIdx != -1 && uri.lastIndexOf(47) < extIdx) {
            matchNoExt = uri.substring(0, extIdx);
        }
        method = method.toUpperCase();
        for (IndexEntry entry : this.index.keySet()) {
            String test;
            String string = test = entry.getIncludeExtension() ? match : matchNoExt;
            Map<String, String> vars = entry.getTemplate().match(test);
            if (vars == null) continue;
            pathMatch = entry;
            varsMatch = vars;
            if (!entry.getMethod().equals(method)) continue;
            scriptMatch = new Match(entry.getTemplate().getTemplate(), vars, entry.getStaticTemplate(), entry.getScript());
            break;
        }
        if (scriptMatch == null && pathMatch != null) {
            scriptMatch = new Match(pathMatch.getTemplate().getTemplate(), varsMatch, pathMatch.getStaticTemplate());
        }
        return scriptMatch;
    }

    public void registerUri(WebScript script, String uri) {
        IndexEntry entry;
        Description desc = script.getDescription();
        boolean extension = true;
        int queryArgIdx = uri.indexOf(63);
        if (queryArgIdx != -1) {
            uri = uri.substring(0, queryArgIdx);
        }
        if (desc.getFormatStyle() != Description.FormatStyle.argument) {
            int extIdx = uri.lastIndexOf(".");
            if (extIdx != -1) {
                uri = uri.substring(0, extIdx);
            }
            extension = false;
        }
        if (this.index.containsKey(entry = new IndexEntry(desc.getMethod(), new UriTemplate(uri), extension, script))) {
            IndexEntry existingEntry = this.index.get(entry);
            WebScript existingService = existingEntry.getScript();
            if (!existingService.getDescription().getId().equals(desc.getId())) {
                String msg = "Web Script document " + desc.getDescPath() + " is attempting to define the url '" + entry + "' already defined by " + existingService.getDescription().getDescPath();
                throw new WebScriptException(msg);
            }
        } else {
            this.index.put(entry, entry);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Indexed URI '" + uri + "' as '" + entry.getTemplate() + "'"));
            }
        }
    }

    static class IndexEntry {
        private String method;
        private UriTemplate template;
        private WebScript script;
        private boolean includeExtension;
        private String staticTemplate;
        private final String key;

        IndexEntry(String method, UriTemplate template, boolean includeExtension, WebScript script) {
            this.method = method.toUpperCase();
            this.template = template;
            this.includeExtension = includeExtension;
            this.script = script;
            this.key = template.getRegex() + ":" + this.method;
            int firstTokenIdx = template.getTemplate().indexOf(123);
            this.staticTemplate = firstTokenIdx == -1 ? template.getTemplate() : template.getTemplate().substring(0, firstTokenIdx);
        }

        public String getMethod() {
            return this.method;
        }

        public UriTemplate getTemplate() {
            return this.template;
        }

        public String getStaticTemplate() {
            return this.staticTemplate;
        }

        public boolean getIncludeExtension() {
            return this.includeExtension;
        }

        public WebScript getScript() {
            return this.script;
        }

        public final String toString() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexEntry)) {
                return false;
            }
            return this.key.equals(((IndexEntry)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

