/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;

@ScriptClass(help="Render script url independent of script hosting environment e.g. render inside / outside\n\nUsage: scripturl(String url)", code="${scripturl(\"?nodeRef=\" + n.parent.nodeRef + \"&n=\" + n.nodeRef + \"&a=p\")}", types={ScriptClassType.TemplateAPI})
public final class ScriptUrlMethod
implements TemplateMethodModelEx {
    WebScriptRequest req;
    WebScriptResponse res;

    public ScriptUrlMethod(WebScriptRequest req, WebScriptResponse res) {
        this.req = req;
        this.res = res;
    }

    public Object exec(List args) throws TemplateModelException {
        String result = "";
        if (args.size() != 0) {
            Object arg0 = args.get(0);
            boolean prefixServiceUrl = true;
            if (args.size() == 2 && args.get(1) instanceof TemplateBooleanModel) {
                prefixServiceUrl = ((TemplateBooleanModel)args.get(1)).getAsBoolean();
            }
            if (arg0 instanceof TemplateScalarModel) {
                String arg = ((TemplateScalarModel)arg0).getAsString();
                StringBuffer buf = new StringBuffer(128);
                if (prefixServiceUrl) {
                    buf.append(this.req.getServicePath());
                    if (arg.length() > 0) {
                        if (arg.indexOf(63) == -1) {
                            buf.append('?');
                        }
                        buf.append(arg);
                    }
                } else {
                    buf.append(arg);
                }
                if (buf.indexOf("?guest") == -1 && buf.indexOf("&guest") == -1) {
                    buf.append(buf.indexOf("?") == -1 ? (char)'?' : '&');
                    buf.append("guest=" + (this.req.isGuest() ? "true" : ""));
                }
                if (this.req.getFormatStyle() == Description.FormatStyle.argument && buf.indexOf("?format") == -1 && buf.indexOf("&format") == -1) {
                    buf.append(buf.indexOf("?") == -1 ? (char)'?' : '&');
                    buf.append("format=" + this.req.getFormat());
                }
                result = this.res.encodeScriptUrl(buf.toString());
            }
        }
        return result;
    }
}

