/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebScriptPropertyResourceBundle
extends PropertyResourceBundle {
    private static final Log logger = LogFactory.getLog(WebScriptPropertyResourceBundle.class);
    private String resourcePath = null;
    private HashMap<String, Object> mergedBundles = new HashMap();
    private StringBuilder mergedBundlePaths = new StringBuilder();

    public String getResourcePath() {
        return this.resourcePath;
    }

    public WebScriptPropertyResourceBundle(InputStream stream, String resourcePath) throws IOException {
        super(stream);
        this.resourcePath = resourcePath;
        this.merge(this);
    }

    public void reset() {
        this.mergedBundles.clear();
        this.mergedBundlePaths = new StringBuilder();
        this.merge(this);
    }

    public String getMergedBundlePaths() {
        return this.mergedBundlePaths.toString();
    }

    public boolean merge(ResourceBundle resourceBundle) {
        boolean merged = false;
        if (resourceBundle != null) {
            if (resourceBundle.getLocale() == null && this.getLocale() == null || resourceBundle.getLocale().equals(this.getLocale())) {
                if (resourceBundle instanceof WebScriptPropertyResourceBundle) {
                    Enumeration<String> keys = ((WebScriptPropertyResourceBundle)resourceBundle).getWrappedKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        this.mergedBundles.put(key, ((WebScriptPropertyResourceBundle)resourceBundle).getWrappedObject(key));
                    }
                    this.mergedBundlePaths.append(((WebScriptPropertyResourceBundle)resourceBundle).getResourcePath());
                    this.mergedBundlePaths.append(":");
                } else {
                    Enumeration<String> keys = resourceBundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        this.mergedBundles.put(key, resourceBundle.getObject(key));
                    }
                }
                merged = true;
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("It is not possible to merge differing locales for: '" + this.resourcePath + "' (attempting to merge " + resourceBundle.getLocale() + " into " + this.getLocale() + ")"));
            }
        }
        return merged;
    }

    @Override
    public Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.mergedBundles.get(key);
    }

    public Object getWrappedObject(String key) {
        return super.handleGetObject(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        Vector<String> keys = new Vector<String>(this.mergedBundles.keySet());
        return keys.elements();
    }

    public Enumeration<String> getWrappedKeys() {
        return super.getKeys();
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.mergedBundles.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.mergedBundles.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.mergedBundles.keySet();
    }
}

