/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.extensions.config.RemoteConfigElement;

public final class EndpointManager {
    private static final long DEFAULT_RECONNECT_TIMEOUT = 20000L;
    private static ConcurrentMap<String, Long> endpointTimeouts = new ConcurrentHashMap<String, Long>();
    private static ConcurrentMap<String, Long> endpointReconnectValues = new ConcurrentHashMap<String, Long>();

    private EndpointManager() {
    }

    public static void registerEndpoint(String endpoint) {
        EndpointManager.registerEndpoint(endpoint, null);
    }

    public static void registerEndpoint(String endpoint, RemoteConfigElement.ConnectorDescriptor descriptor) {
        endpointTimeouts.putIfAbsent(endpoint, 0L);
        if (!endpointReconnectValues.containsKey(endpoint)) {
            String strConnTimeout;
            long connTimeout = 20000L;
            if (descriptor != null && (strConnTimeout = descriptor.getReconnectTimeout()) != null && strConnTimeout.length() != 0) {
                connTimeout = Long.parseLong(strConnTimeout);
            }
            endpointReconnectValues.put(endpoint, connTimeout);
        }
    }

    public static boolean allowConnect(String endpoint) {
        return (Long)endpointTimeouts.get(endpoint) + (Long)endpointReconnectValues.get(endpoint) < System.currentTimeMillis();
    }

    public static boolean processResponseCode(String endpoint, int code) {
        boolean allowContinue = true;
        if (498 == code || 499 == code) {
            endpointTimeouts.put(endpoint, System.currentTimeMillis());
            allowContinue = false;
        }
        return allowContinue;
    }
}

