/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.jsf;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.AbstractRuntime;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptRequestURLImpl;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptSession;
import org.springframework.extensions.webscripts.WebScriptSessionFactory;
import org.springframework.extensions.webscripts.jsf.WebScriptJSFRequest;
import org.springframework.extensions.webscripts.jsf.WebScriptJSFResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletSession;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class UIWebScript
extends SelfRenderingComponent {
    private static Log logger = LogFactory.getLog(UIWebScript.class);
    private String scriptUrl = null;
    private boolean scriptUrlModified = false;
    private Object context = null;
    private RuntimeContainer container;

    public UIWebScript() {
        WebApplicationContext ctx = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)FacesContext.getCurrentInstance());
        this.container = (RuntimeContainer)ctx.getBean("webscripts.container");
    }

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.scriptUrl = (String)values[1];
        this.scriptUrlModified = (Boolean)values[2];
        this.context = values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.scriptUrl, this.scriptUrlModified, this.context};
        return values;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof WebScriptEvent) {
            this.scriptUrlModified = true;
            this.scriptUrl = ((WebScriptEvent)event).Url;
        } else {
            super.broadcast(event);
        }
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getClientId(context));
        if (value != null && value.length() != 0) {
            String url = URLDecoder.decode((String)value);
            this.queueEvent((FacesEvent)new WebScriptEvent((UIComponent)this, url));
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String scriptUrl = this.getScriptUrl();
        Object scriptContext = this.getContext();
        if (scriptContext != null) {
            if (scriptContext instanceof Map) {
                Map scriptContextMap = (Map)scriptContext;
                for (String key : scriptContextMap.keySet()) {
                    scriptUrl = scriptUrl.replace("{" + key + "}", scriptContextMap.get(key).toString());
                }
            } else {
                scriptUrl = scriptUrl.replace("{noderef}", scriptContext.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing UIWebScript encodeBegin(): " + scriptUrl));
        }
        WebScriptJSFRuntime runtime = new WebScriptJSFRuntime(this.container, context, scriptUrl);
        runtime.executeScript();
    }

    public void setScriptUrl(String scriptUrl) {
        this.scriptUrl = this.getFacesContext().getExternalContext().getRequestContextPath() + scriptUrl;
    }

    public String getScriptUrl() {
        ValueBinding vb;
        if (!this.scriptUrlModified && (vb = this.getValueBinding("scriptUrl")) != null) {
            this.scriptUrl = this.getFacesContext().getExternalContext().getRequestContextPath() + (String)vb.getValue(this.getFacesContext());
        }
        return this.scriptUrl;
    }

    public Object getContext() {
        ValueBinding vb = this.getValueBinding("context");
        if (vb != null) {
            this.context = vb.getValue(this.getFacesContext());
        }
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    private class WebScriptJSFRuntime
    extends AbstractRuntime {
        private FacesContext fc;
        private String[] scriptUrlParts;

        WebScriptJSFRuntime(RuntimeContainer container, FacesContext fc, String scriptUrl) {
            super(container);
            this.fc = fc;
            String contextPath = fc.getExternalContext().getRequestContextPath();
            this.scriptUrlParts = WebScriptRequestURLImpl.splitURL(contextPath, scriptUrl);
        }

        public String getName() {
            return "JSF";
        }

        protected Authenticator createAuthenticator() {
            return null;
        }

        protected WebScriptRequest createRequest(Match match) {
            return new WebScriptJSFRequest((Runtime)this, this.scriptUrlParts, match);
        }

        protected WebScriptResponse createResponse() {
            return new WebScriptJSFResponse(this, this.fc, UIWebScript.this);
        }

        protected WebScriptSessionFactory createSessionFactory() {
            return new WebScriptSessionFactory(){

                public WebScriptSession createSession() {
                    return new WebScriptServletSession((HttpSession)WebScriptJSFRuntime.this.fc.getExternalContext().getSession(false));
                }
            };
        }

        protected String getScriptMethod() {
            return "GET";
        }

        protected String getScriptUrl() {
            return this.scriptUrlParts[2];
        }
    }

    public static class WebScriptEvent
    extends ActionEvent {
        public String Url = null;

        public WebScriptEvent(UIComponent component, String url) {
            super(component);
            this.Url = url;
        }
    }
}

