/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.types.Extension;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.webscripts.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeploymentService {
    private static final Log logger = LogFactory.getLog(ModuleDeploymentService.class);
    private WebFrameworkConfigElement webFrameworkConfiguration;
    private ModelObjectService modelObjectService;
    private Registry webScriptRegistry = null;
    private Date lastConfigurationUpdate = new Date();
    private ThreadLocal<List<String>> currThreadErrors = new ThreadLocal();
    private Map<String, ExtensionModule> configuredModules = null;
    private List<ExtensionModule> undeployedModules = null;
    private List<ModuleDeployment> deployedModules = null;

    public void setWebFrameworkConfiguration(WebFrameworkConfigElement webFrameworkConfiguration) {
        this.webFrameworkConfiguration = webFrameworkConfiguration;
    }

    public ModelObjectService getModelObjectService() {
        return this.modelObjectService;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setWebScriptRegistry(Registry webScriptRegistry) {
        this.webScriptRegistry = webScriptRegistry;
    }

    public synchronized Date getLastConfigurationUpdate() {
        return this.lastConfigurationUpdate;
    }

    public List<String> getCurrentThreadErrors() {
        List<String> currErrors = this.currThreadErrors.get();
        if (currErrors == null) {
            currErrors = new ArrayList<String>();
        }
        return currErrors;
    }

    public void clearCurrentThreadErrors() {
        this.currThreadErrors.get().clear();
    }

    public synchronized List<ExtensionModule> getUndeployedModules() {
        if (this.undeployedModules == null) {
            this.getDeployedModules();
        }
        return this.undeployedModules;
    }

    private synchronized Map<String, ExtensionModule> getAllConfiguredExtensionModules() {
        if (this.configuredModules == null) {
            this.configuredModules = new HashMap<String, ExtensionModule>();
            Map<String, ModelObject> allExtensions = this.modelObjectService.getAllObjects("extension");
            for (ModelObject extension : allExtensions.values()) {
                if (!(extension instanceof Extension)) continue;
                for (ExtensionModule module : ((Extension)extension).getExtensionModules()) {
                    this.configuredModules.put(module.getId(), module);
                }
            }
        }
        return this.configuredModules;
    }

    public synchronized List<ModuleDeployment> getDeployedModules() {
        if (this.deployedModules == null) {
            this.getAllConfiguredExtensionModules();
            String moduleDeploymentMode = this.webFrameworkConfiguration.getModuleDeploymentMode();
            if (moduleDeploymentMode == null || moduleDeploymentMode.equals("auto")) {
                this.deployedModules = new ArrayList<ModuleDeployment>();
                int i = 0;
                for (ExtensionModule module : this.configuredModules.values()) {
                    this.deployedModules.add(this.deployModule(module, i++, null, null));
                }
                this.undeployedModules = new ArrayList<ExtensionModule>();
            } else {
                this.undeployedModules = new ArrayList<ExtensionModule>();
                this.undeployedModules.addAll(this.configuredModules.values());
                this.deployedModules = new ArrayList<ModuleDeployment>();
                for (ExtensionModule configuredModule : this.configuredModules.values()) {
                    ModelObject o = this.modelObjectService.getObject("module-deployment", configuredModule.getId());
                    if (!(o instanceof ModuleDeployment)) continue;
                    ModuleDeployment modDep = (ModuleDeployment)o;
                    modDep.setExtensionModule(configuredModule);
                    this.deployedModules.add(modDep);
                    this.undeployedModules.remove(configuredModule);
                }
                int i = 0;
                if (!this.deployedModules.isEmpty()) {
                    ModuleDeployment lastDeployedModule = this.deployedModules.get(this.deployedModules.size() - 1);
                    i = lastDeployedModule.getIndex();
                }
                if (this.webFrameworkConfiguration.isModuleAutoDeployEnabled()) {
                    ArrayList<ExtensionModule> autoDeployed = new ArrayList<ExtensionModule>();
                    for (ExtensionModule module : this.undeployedModules) {
                        if (!module.isAutoDeploy()) continue;
                        this.deployedModules.add(this.deployModule(module, ++i, null, null));
                        autoDeployed.add(module);
                    }
                    this.undeployedModules.removeAll(autoDeployed);
                }
            }
            this.saveDeployedModuleConfigurations();
        }
        return this.deployedModules;
    }

    private synchronized void saveDeployedModuleConfigurations() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Saving module deployment configuration...");
        }
        Collections.sort(this.deployedModules);
        ArrayList<String> errors = new ArrayList<String>();
        boolean saveFail = false;
        for (int i = 0; i < this.deployedModules.size(); ++i) {
            ModuleDeployment currentDeployedModule = this.deployedModules.get(i);
            currentDeployedModule.setIndex(i);
            try {
                if (this.modelObjectService.saveObject(currentDeployedModule)) continue;
                saveFail = true;
                errors.add("Could not save module: \"" + currentDeployedModule.getId() + "\"");
                logger.error((Object)("Could not save module deployment for: \"" + currentDeployedModule.getId() + "\""));
                continue;
            }
            catch (ModelObjectPersisterException e) {
                logger.error((Object)"Could not save module deployment configuration", (Throwable)e);
                errors.add("The following exception was thrown: " + e.getLocalizedMessage());
            }
        }
        if (saveFail) {
            errors.add("Could not save deployment configuration, please ensure you are authenticated. Changes will not survive server restart.");
        }
        this.lastConfigurationUpdate = new Date();
        this.currThreadErrors.set(errors);
    }

    public synchronized void setDeployedModules(List<JSONObject> modulesToDeploy) throws JSONException {
        this.getAllConfiguredExtensionModules();
        this.getDeployedModules();
        this.getUndeployedModules();
        for (ModuleDeployment depMod : this.deployedModules) {
            String modIdToRemove = depMod.getExtensionModuleId();
            ExtensionModule modToRemove = this.configuredModules.get(modIdToRemove);
            if (!this.undeployedModules.contains(modToRemove)) {
                this.undeployedModules.add(modToRemove);
            }
            this.modelObjectService.removeObject(depMod);
        }
        this.deployedModules.clear();
        if (modulesToDeploy != null) {
            for (int i = 0; i < modulesToDeploy.size(); ++i) {
                ModuleDeployment modDep;
                JSONObject moduleToDeploy = modulesToDeploy.get(i);
                String moduleId = moduleToDeploy.getString("id");
                String evaluatorOverride = null;
                if (moduleToDeploy.has("evaluatorOverrideId")) {
                    evaluatorOverride = moduleToDeploy.getString("evaluatorOverrideId");
                }
                HashMap<String, String> evalPropOverrides = null;
                if (moduleToDeploy.has("evaluatorPropertyOverrides")) {
                    JSONObject evalPropOverridesJSON = moduleToDeploy.getJSONObject("evaluatorPropertyOverrides");
                    evalPropOverrides = new HashMap<String, String>();
                    Iterator propKeys = evalPropOverridesJSON.keys();
                    while (propKeys.hasNext()) {
                        String propKey = (String)propKeys.next();
                        evalPropOverrides.put(propKey, (String)evalPropOverridesJSON.get(propKey));
                    }
                }
                ExtensionModule targetModule = null;
                Iterator<ExtensionModule> extModIter = this.configuredModules.values().iterator();
                while (targetModule == null && extModIter.hasNext()) {
                    ExtensionModule currExtMod = extModIter.next();
                    if (currExtMod == null || currExtMod.getId() == null || !currExtMod.getId().equals(moduleId)) continue;
                    targetModule = currExtMod;
                }
                if (targetModule == null || (modDep = this.deployModule(targetModule, i, evaluatorOverride, evalPropOverrides)) == null) continue;
                this.deployedModules.add(modDep);
                this.undeployedModules.remove(targetModule);
            }
        }
        if (this.webScriptRegistry != null) {
            this.webScriptRegistry.reset();
        }
        this.saveDeployedModuleConfigurations();
    }

    private synchronized ModuleDeployment deployModule(ExtensionModule moduleToDeploy, int index, String evaluatorOverride, Map<String, String> evaluatorPropertyOverrides) {
        ModuleDeployment modDep = (ModuleDeployment)this.modelObjectService.newObject("module-deployment", moduleToDeploy.getId());
        modDep.setIndex(index);
        modDep.setExtensionModuleId(moduleToDeploy.getId());
        modDep.setExtensionModule(moduleToDeploy);
        if (evaluatorOverride != null) {
            modDep.setEvaluatorOverride(evaluatorOverride);
        }
        if (evaluatorPropertyOverrides != null) {
            modDep.setEvaluatorPropertyOverrides(evaluatorPropertyOverrides);
        }
        return modDep;
    }

    public synchronized boolean deleteModuleDeployment(ModuleDeployment moduleDeploymentToDelete) {
        boolean deleted = false;
        List<ExtensionModule> undeployedModules = this.getUndeployedModules();
        List<ModuleDeployment> deployedModules = this.getDeployedModules();
        if (deployedModules.contains(moduleDeploymentToDelete)) {
            undeployedModules.add(this.configuredModules.get(moduleDeploymentToDelete.getExtensionModuleId()));
            this.modelObjectService.removeObject(moduleDeploymentToDelete);
            this.lastConfigurationUpdate = new Date();
            deleted = true;
        }
        return deleted;
    }
}

