/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.support.ServletRequestContextFactory;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

public final class RequestContextUtil {
    private static Log logger = LogFactory.getLog(RequestContextUtil.class);

    public static RequestContext initRequestContext(ApplicationContext applicationContext, HttpServletRequest request) throws RequestContextException {
        return RequestContextUtil.initRequestContext(applicationContext, request, false);
    }

    public static RequestContext initRequestContext(ApplicationContext applicationContext, HttpServletRequest request, boolean silentInit) throws RequestContextException {
        ServletUtil.setRequest(request);
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context == null) {
            ServletRequestContextFactory factory = (ServletRequestContextFactory)applicationContext.getBean("webframework.factory.requestcontext.servlet");
            context = factory.newInstance((WebRequest)new ServletWebRequest(request));
            request.setAttribute("requestContext", (Object)context);
            try {
                RequestContextUtil.populateRequestContext(context, request, silentInit);
            }
            catch (UserFactoryException ufe) {
                throw new RequestContextException("Unable to load user during request context population", ufe);
            }
            catch (ResourceLoaderException rle) {
                throw new RequestContextException("Unable to load resource during request context population", rle);
            }
        }
        request.setAttribute("requestContext", (Object)context);
        if (!silentInit) {
            try {
                RequestContextUtil.initialiseUser(context, request);
            }
            catch (UserFactoryException ufe) {
                throw new RequestContextException("Unable to fault user as safeguard during init request context", ufe);
            }
        }
        return context;
    }

    public static void populateRequestContext(RequestContext context, HttpServletRequest request) throws UserFactoryException, ResourceLoaderException {
        RequestContextUtil.populateRequestContext(context, request, false);
    }

    public static void populateRequestContext(RequestContext context, HttpServletRequest request, boolean silentInit) throws UserFactoryException, ResourceLoaderException {
        Resource resource;
        String resourceId;
        String formatId = request.getParameter("f");
        if (formatId == null || formatId.length() == 0) {
            formatId = context.getServiceRegistry().getWebFrameworkConfiguration().getDefaultFormatId();
        }
        if (formatId != null) {
            context.setFormatId(formatId);
        }
        if ((resourceId = request.getParameter("o")) != null && resourceId.length() != 0 && (resource = context.getServiceRegistry().getResourceService().getResource(resourceId)) != null) {
            context.setCurrentObject(resource);
        }
        if (!silentInit) {
            RequestContextUtil.initialiseUser(context, request);
        }
        if (context.getTheme() == null) {
            Theme theme = null;
            String themeId = null;
            Configuration siteConfiguration = context.getSiteConfiguration();
            if (siteConfiguration != null) {
                themeId = siteConfiguration.getProperty("theme");
            }
            if (themeId == null && (themeId = FrameworkUtil.getWebFrameworkConfiguration().getDefaultThemeId()) == null) {
                themeId = "default";
            }
            if (themeId != null && (theme = context.getObjectService().getTheme(themeId)) == null) {
                logger.warn((Object)("Unable to locate theme model object with ID: " + themeId));
            }
            if (theme != null) {
                context.setTheme(theme);
            }
        }
        if (context.getSiteConfiguration() == null) {
            context.setPage(null);
            context.setCurrentObject(null);
        }
    }

    private static void initialiseUser(RequestContext context, HttpServletRequest request) throws UserFactoryException {
        if (context.getUser() == null) {
            String userEndpointId = (String)((Object)context.getAttribute("alfUserEndpoint"));
            UserFactory userFactory = context.getServiceRegistry().getUserFactory();
            User user = userFactory.initialiseUser(context, request, userEndpointId);
            context.setUser(user);
        }
    }
}

