/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.impl.JSONMergingContentModelElement;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.ScriptUser;
import org.springframework.extensions.webscripts.URLHelper;

public class JavaScriptContentModelElement
extends JSONMergingContentModelElement {
    private static final Log logger = LogFactory.getLog(JavaScriptContentModelElement.class);
    public static final String TYPE = "WIDGET_CONTENT";
    private Environment env = null;
    private String javaScriptType = null;

    public JavaScriptContentModelElement(String id, String directiveName, Environment env) {
        super(id, directiveName);
        this.env = env;
    }

    public String getJavaScriptType() {
        if (this.javaScriptType == null) {
            this.javaScriptType = "surf.Component";
        }
        return this.javaScriptType;
    }

    public void setJavaScriptType(String javaScriptType) {
        this.javaScriptType = javaScriptType;
    }

    public String flushContent() {
        StringBuilder toFlush;
        block7: {
            toFlush = new StringBuilder();
            try {
                Object unwrapped = DeepUnwrap.permissiveUnwrap((TemplateModel)this.env.getDataModel());
                if (unwrapped instanceof Map) {
                    Map<String, String> templateArgs;
                    URLHelper urlHelper;
                    Map model = (Map)unwrapped;
                    String htmlId = (String)model.get("htmlid");
                    String messages = (String)model.get("messages");
                    Map args = (Map)model.get("args");
                    ScriptUser user = (ScriptUser)model.get("user");
                    Map page = (Map)model.get("page");
                    Description webScript = (Description)model.get("webscript");
                    String site = (String)args.get("site");
                    if (site == null && page != null && (urlHelper = (URLHelper)page.get("url")) != null && (templateArgs = urlHelper.getTemplateArgs()) != null) {
                        site = templateArgs.get("site");
                    }
                    StringBuilder context = new StringBuilder();
                    context.append("{");
                    if (args != null && args.containsKey("channel")) {
                        context.append("channel: \"" + args.get("channel") + "\", ");
                    }
                    context.append("site: \"" + site + "\", ");
                    if (user != null) {
                        context.append("user: { ");
                        context.append("id: \"" + (user.getId() == null ? "" : user.getId()) + "\", ");
                        context.append("firstName: \"" + (user.getFirstName() == null ? "" : user.getFirstName()) + "\", ");
                        context.append("lastName: \"" + (user.getLastName() == null ? "" : user.getLastName()) + "\", ");
                        context.append("email: \"" + (user.getEmail() == null ? "" : user.getEmail()) + "\", ");
                        context.append("},");
                    }
                    if (webScript != null) {
                        context.append("id: \"" + webScript.getId() + "\" }");
                    }
                    toFlush.append("<script type=\"text/javascript\">//![CDATA\n");
                    toFlush.append("   var component = new " + this.getJavaScriptType() + "(\"" + htmlId + "\").setCtx(" + context + ").setMessages(" + messages + ");\n");
                    toFlush.append("   var contentToMerge = " + this.jsonMerge() + ";\n");
                    toFlush.append("   Surf.merge(component, contentToMerge);\n");
                    toFlush.append("   component.start();\n");
                    toFlush.append("//]]</script>\n\n");
                }
            }
            catch (TemplateModelException e) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error((Object)("The following error occurred processing JSON for: " + this.getId()), (Throwable)e);
            }
        }
        return toFlush.toString();
    }

    public String getType() {
        return TYPE;
    }
}

