/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import org.dom4j.Document;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.ContentAssociation;

public class ContentAssociationImpl
extends AbstractModelObject
implements ContentAssociation {
    public ContentAssociationImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
    }

    public String getTypeId() {
        return "content-association";
    }

    public String getSourceId() {
        return this.getProperty("source-id");
    }

    public void setSourceId(String sourceId) {
        this.setProperty("source-id", sourceId);
    }

    public String getDestId() {
        return this.getProperty("dest-id");
    }

    public void setDestId(String destId) {
        this.setProperty("dest-id", destId);
    }

    public String getAssociationType() {
        return this.getProperty("assoc-type");
    }

    public void setSourceType(String sourceType) {
        this.setProperty("source-type", sourceType);
    }

    public String getSourceType() {
        return this.getProperty("source-type");
    }

    public void setAssociationType(String associationType) {
        this.setProperty("assoc-type", associationType);
    }

    public String getFormatId() {
        return this.getProperty("format-id");
    }

    public void setFormatId(String formatId) {
        this.setProperty("format-id", formatId);
    }

    public ModelObject getObject(RequestContext context) {
        ModelObject modelObject = null;
        if (this.isTemplateAssociation()) {
            modelObject = context.getObjectService().getTemplate(this.getDestId());
        } else if (this.isPageAssociation()) {
            modelObject = context.getObjectService().getPage(this.getDestId());
        }
        return modelObject;
    }

    public boolean isTemplateAssociation() {
        return this.getAssociationType() == null || "template".equalsIgnoreCase(this.getAssociationType());
    }

    public boolean isPageAssociation() {
        return "page".equalsIgnoreCase(this.getAssociationType());
    }
}

