/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Extension;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
extends AbstractModelObject
implements Extension {
    private static final long serialVersionUID = -7611883161758132916L;
    public static final String MODULE = "module";
    private List<ExtensionModule> modules = new ArrayList<ExtensionModule>();

    @Override
    public String getTypeId() {
        return "extension";
    }

    public ExtensionImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        List modulesDefinitionList = this.getDocument().getRootElement().elements("modules");
        for (Element modulesDefinition : modulesDefinitionList) {
            List moduleDefinitionList = XMLUtil.getChildren(modulesDefinition);
            for (Element moduleDefinition : moduleDefinitionList) {
                if (!moduleDefinition.getName().equals(MODULE)) continue;
                this.modules.add(new ExtensionModule(moduleDefinition, key));
            }
        }
    }

    @Override
    public List<ExtensionModule> getExtensionModules() {
        return this.modules;
    }

    @Override
    public String getExtensionType() {
        return this.getProperty("extension-type");
    }

    @Override
    public void setExtensionType(String extensionType) {
        this.setProperty("extension-type", extensionType);
    }
}

