/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.AdvancedComponent;
import org.springframework.extensions.surf.types.Customization;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.surf.types.XMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeploymentImpl
extends AbstractModelObject
implements ModuleDeployment {
    private static final Log logger = LogFactory.getLog(ModuleDeploymentImpl.class);
    private static final long serialVersionUID = -7611883161758132916L;
    private ExtensionModule extensionModule;
    private int index = 0;

    @Override
    public String getTypeId() {
        return "module-deployment";
    }

    public ModuleDeploymentImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
    }

    @Override
    public String getModuleDeploymentType() {
        return this.getProperty("module-deployment-type");
    }

    @Override
    public void setModuleDeploymentType(String extensionType) {
        this.setProperty("module-deployment-type", extensionType);
    }

    @Override
    public String getExtensionModuleId() {
        return this.getProperty("extension-module");
    }

    @Override
    public void setExtensionModuleId(String extensionModuleId) {
        this.setProperty("extension-module", extensionModuleId);
    }

    @Override
    public ExtensionModule getExtensionModule() {
        return this.extensionModule;
    }

    @Override
    public void setExtensionModule(ExtensionModule extensionModule) {
        this.extensionModule = extensionModule;
    }

    @Override
    public int getIndex() {
        int index = 0;
        try {
            String indexString = this.getProperty("index");
            if (indexString != null) {
                index = Integer.parseInt(indexString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return index;
    }

    @Override
    public void setIndex(int index) {
        this.setProperty("index", Integer.toString(index));
    }

    @Override
    public int compareTo(ModuleDeployment o) {
        return this.index - o.getIndex();
    }

    public boolean equals(Object obj) {
        String id;
        boolean equals = false;
        if (obj instanceof ModuleDeployment && (id = ((ModuleDeployment)obj).getId()) != null && id.equals(this.id)) {
            equals = true;
        }
        if (!equals && obj instanceof ExtensionModule && (id = ((ExtensionModule)obj).getId()) != null && id.equals(this.id)) {
            equals = true;
        }
        return equals;
    }

    @Override
    public String getEvaluator() {
        String evaluator = this.getEvaluatorOverride();
        if (evaluator == null) {
            evaluator = this.extensionModule.getEvaluator();
        }
        return evaluator;
    }

    @Override
    public Map<String, String> getEvaluatorProperties() {
        Map<String, String> properties = this.getEvaluatorPropertyOverrides();
        if (properties == null) {
            properties = this.extensionModule.getEvaluatorProperties();
        }
        return properties;
    }

    @Override
    public void setEvaluatorOverride(String evaluatorOverride) {
        this.setProperty("evaluator-override", evaluatorOverride);
    }

    @Override
    public void setEvaluatorPropertyOverrides(Map<String, String> evaluatorProperties) {
        Element evalPropOverrideEl = this.document.getRootElement().element("evaluator-property-overrides");
        if (evalPropOverrideEl == null) {
            evalPropOverrideEl = this.document.getRootElement().addElement("evaluator-property-overrides");
        }
        evalPropOverrideEl.clearContent();
        for (Map.Entry<String, String> currProp : evaluatorProperties.entrySet()) {
            Element newProp = evalPropOverrideEl.addElement(currProp.getKey());
            newProp.setText(currProp.getValue());
        }
    }

    @Override
    public String getEvaluatorOverride() {
        return this.getProperty("evaluator-override");
    }

    @Override
    public Map<String, String> getEvaluatorPropertyOverrides() {
        Map<String, String> evaluatorProperties = null;
        Element evalPropOverrideEl = this.document.getRootElement().element("evaluator-property-overrides");
        if (evalPropOverrideEl != null) {
            evaluatorProperties = XMLHelper.getProperties("evaluator-property-overrides", this.document.getRootElement());
        }
        return evaluatorProperties;
    }

    public Map<String, AdvancedComponent> getAdvancedComponents() {
        HashMap<String, AdvancedComponent> advancedComponents = null;
        if (this.extensionModule == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("ModuleDeployment '" + this.id + "' does not have an associated ExtensionModule - returning empty advanced component list"));
            }
            advancedComponents = new HashMap();
        } else {
            advancedComponents = this.extensionModule.getAdvancedComponents();
            if (advancedComponents == null) {
                advancedComponents = new HashMap();
            }
        }
        return advancedComponents;
    }

    @Override
    public AdvancedComponent getAdvancedComponent(String id) {
        AdvancedComponent component = this.getAdvancedComponents().get(id);
        return component;
    }

    @Override
    public List<Customization> getCustomizations() {
        List<Customization> customizations = null;
        if (this.extensionModule == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("ModuleDeployment '" + this.id + "' does not have an associated ExtensionModule - returning empty customizations list"));
            }
            customizations = new ArrayList<Customization>();
        } else {
            customizations = this.extensionModule.getCustomizations();
        }
        return customizations;
    }
}

