/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.DataUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;

public class XMLUtil {
    protected static Log logger = LogFactory.getLog(XMLUtil.class);

    public static void addChildValue(Element parent, String childName, String childValue) {
        XMLUtil.setChildValue(parent, childName, childValue);
    }

    public static Element getChild(Element parent, String name) {
        return parent.element(name);
    }

    public static String getValue(Element element) {
        return element.getTextTrim();
    }

    public static void setValue(Element element, String value) {
        element.clearContent();
        element.setText(value);
    }

    public static String getChildValue(Element element, String name) {
        Element child = XMLUtil.getChild(element, name);
        if (child != null) {
            return XMLUtil.getValue(child);
        }
        return null;
    }

    public static void setChildValue(Element element, String name, String value) {
        Element child = XMLUtil.getChild(element, name);
        if (child == null) {
            child = element.addElement(name);
        }
        if (child != null) {
            XMLUtil.setValue(child, value);
        }
    }

    public static List getChildren(Element element) {
        return XMLUtil.getChildren(element, null);
    }

    public static List getChildren(Element element, String name) {
        if (name == null) {
            return element.elements();
        }
        return element.elements(name);
    }

    public static String getAttribute(Element element, String attributeName) {
        return element.attributeValue(attributeName);
    }

    public static String getDocumentChildValue(Document d, String name) {
        return XMLUtil.getChildValue(d.getRootElement(), name);
    }

    public static void setDocumentChildValue(Document d, String name, String value) throws Exception {
        XMLUtil.setChildValue(d.getRootElement(), name, value);
    }

    public static Document parse(String xml) throws DocumentException {
        return DocumentHelper.parseText((String)xml);
    }

    public static Document parse(InputStream stream) throws DocumentException, IOException {
        return XMLUtil.parse(DataUtil.copyToString(stream, "UTF-8", true));
    }

    public static String toXML(Document document) {
        return XMLUtil.toXML(document, false);
    }

    public static String toXML(Document document, boolean pretty) {
        String xml = null;
        if (pretty) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(false);
            StringBuilderWriter writer = new StringBuilderWriter(256);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            try {
                xmlWriter.write(document);
                xmlWriter.flush();
                xml = writer.toString();
            }
            catch (IOException ioe) {
                logger.debug((Object)ioe);
            }
        }
        if (xml == null) {
            xml = document.asXML();
        }
        return xml;
    }
}

