/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.extensibility.ExtensionModuleEvaluator;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDeployedModules
extends DeclarativeWebScript
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ModuleDeploymentService moduleDeploymentService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        if (this.moduleDeploymentService != null) {
            ArrayList<String> deployedModules = new ArrayList<String>();
            ArrayList<String> undeployedModules = new ArrayList<String>();
            for (ModuleDeployment deployedModule : this.moduleDeploymentService.getDeployedModules()) {
                try {
                    deployedModules.add(this.createModuleDefinition(deployedModule).toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            for (ExtensionModule undeployedModule : this.moduleDeploymentService.getUndeployedModules()) {
                try {
                    undeployedModules.add(this.createModuleDefinition(undeployedModule).toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            Date lastConfigUpdate = this.moduleDeploymentService.getLastConfigurationUpdate();
            model.put("lastCacheUpdate", lastConfigUpdate != null ? lastConfigUpdate.toString() : "");
            List<String> errors = this.moduleDeploymentService.getCurrentThreadErrors();
            if (!errors.isEmpty()) {
                ArrayList<String> copyOfErrors = new ArrayList<String>();
                copyOfErrors.addAll(errors);
                model.put("errors", copyOfErrors);
                this.moduleDeploymentService.clearCurrentThreadErrors();
            }
            model.put("deployedModules", deployedModules);
            model.put("undeployedModules", undeployedModules);
            if (this.applicationContext != null) {
                ArrayList<String> evaluators = new ArrayList<String>();
                try {
                    JSONObject defaultEvaluator = new JSONObject();
                    defaultEvaluator.put("id", (Object)"");
                    JSONArray defaultEvaluatorReqProps = new JSONArray();
                    defaultEvaluator.put("requiredProps", (Object)defaultEvaluatorReqProps);
                    evaluators.add(defaultEvaluator.toString());
                    Map evaluatorMap = this.applicationContext.getBeansOfType(ExtensionModuleEvaluator.class);
                    for (Map.Entry evaluatorEntry : evaluatorMap.entrySet()) {
                        JSONObject evaluator = new JSONObject();
                        evaluator.put("id", evaluatorEntry.getKey());
                        JSONArray requiredProps = new JSONArray();
                        for (String prop : ((ExtensionModuleEvaluator)evaluatorEntry.getValue()).getRequiredProperties()) {
                            requiredProps.put((Object)prop);
                        }
                        evaluator.put("requiredProps", (Object)requiredProps);
                        evaluators.add(evaluator.toString());
                    }
                    model.put("evaluators", evaluators);
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
        }
        return model;
    }

    private JSONObject createModuleDefinition(ExtensionModule extMod) throws JSONException {
        JSONObject module = new JSONObject();
        module.put("id", (Object)extMod.getId());
        module.put("evaluatorId", (Object)extMod.getEvaluator());
        module.put("evaluatorProperties", (Object)this.createEvaluatorProperties(extMod.getEvaluatorProperties()));
        return module;
    }

    private JSONObject createModuleDefinition(ModuleDeployment modDep) throws JSONException {
        JSONObject module = new JSONObject();
        module.put("id", (Object)modDep.getId());
        ExtensionModule extMod = modDep.getExtensionModule();
        module.put("evaluatorId", (Object)extMod.getEvaluator());
        module.put("evaluatorProperties", (Object)this.createEvaluatorProperties(extMod.getEvaluatorProperties()));
        if (modDep.getEvaluatorOverride() != null) {
            module.put("evaluatorOverrideId", (Object)modDep.getEvaluatorOverride());
        }
        if (modDep.getEvaluatorPropertyOverrides() != null) {
            module.put("evaluatorPropertyOverrides", (Object)this.createEvaluatorProperties(modDep.getEvaluatorPropertyOverrides()));
        }
        return module;
    }

    private JSONObject createEvaluatorProperties(Map<String, String> props) throws JSONException {
        JSONObject evaluatorProperties = new JSONObject();
        for (Map.Entry<String, String> evalProp : props.entrySet()) {
            evaluatorProperties.put(evalProp.getKey(), (Object)evalProp.getValue());
        }
        return evaluatorProperties;
    }
}

