/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostDeployedModules
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(PostDeployedModules.class);
    private ModuleDeploymentService moduleDeploymentService;

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model;
        block7: {
            model = new HashMap<String, Object>(7, 1.0f);
            if (this.moduleDeploymentService != null) {
                ArrayList<JSONObject> modulesToDeploy = new ArrayList<JSONObject>();
                String[] moduleIdsToDeploy = req.getParameterValues("deployedModules");
                if (moduleIdsToDeploy == null) {
                    moduleIdsToDeploy = new String[]{};
                }
                for (String modAsJsonStr : moduleIdsToDeploy) {
                    try {
                        JSONObject modAsJson = new JSONObject(modAsJsonStr);
                        modulesToDeploy.add(modAsJson);
                    }
                    catch (JSONException e) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error((Object)"The following exception occurred when attempting to update module deployment state", (Throwable)e);
                    }
                }
                try {
                    this.moduleDeploymentService.setDeployedModules(modulesToDeploy);
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block7;
                    logger.error((Object)"The following exception occurred when attempting to update module deployment state", (Throwable)e);
                }
            }
        }
        return model;
    }
}

