/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectiveUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringProperty(Map<String, Object> params, String targetProp, String directiveName, boolean required) throws TemplateModelException {
        String str = null;
        TemplateModel value = (TemplateModel)params.get(targetProp);
        if (value != null) {
            if (!(value instanceof TemplateScalarModel)) throw new TemplateModelException("The \"" + targetProp + "\" parameter to the \"" + directiveName + "\" directive must be a string.");
            return ((TemplateScalarModel)value).getAsString();
        }
        if (!required) return str;
        throw new TemplateModelException("The \"" + targetProp + "\" parameter to the \"" + directiveName + "\" directive must be provided.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getBooleanProperty(Map<String, Object> params, String targetProp, String directiveName, boolean required) throws TemplateModelException {
        boolean bool = false;
        TemplateModel value = (TemplateModel)params.get(targetProp);
        if (value != null) {
            if (value instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)value).getAsBoolean();
            }
            if (!(value instanceof TemplateScalarModel)) throw new TemplateModelException("The \"" + targetProp + "\" parameter to the \"" + directiveName + "\" directive must be a boolean.");
            return Boolean.parseBoolean(((TemplateScalarModel)value).getAsString());
        }
        if (!required) return bool;
        throw new TemplateModelException("The \"" + targetProp + "\" parameter to the \"" + directiveName + "\" directive must be provided.");
    }
}

