/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class MessagesWebScript
extends AbstractWebScript {
    protected final Cache cache;
    protected final Map<String, String> messages = new HashMap<String, String>(8);
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public MessagesWebScript() {
        this.cache = new Cache();
        this.cache.setNeverCache(false);
        this.cache.setMustRevalidate(true);
        this.cache.setLastModified(new Date());
        this.cache.setMaxAge(Long.valueOf(6000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String result;
        block7: {
            res.setContentType(Format.JAVASCRIPT.mimetype() + ";charset=UTF-8");
            res.setCache(this.cache);
            String locale = req.getParameter("locale");
            if (locale == null || locale.length() == 0) {
                throw new WebScriptException("Locale parameter is mandatory.");
            }
            result = "";
            this.cacheLock.readLock().lock();
            try {
                result = this.messages.get(locale);
                if (result != null) break block7;
                this.cacheLock.readLock().unlock();
                this.cacheLock.writeLock().lock();
                try {
                    result = this.generateMessages(req, res, locale);
                    this.messages.put(locale, result);
                }
                finally {
                    this.cacheLock.readLock().lock();
                    this.cacheLock.writeLock().unlock();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        res.getWriter().write(result);
        res.getWriter().flush();
        res.getWriter().close();
    }

    protected String generateMessages(WebScriptRequest req, WebScriptResponse res, String locale) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(8192);
        writer.write("if (typeof SpringSurf == \"undefined\" || !SpringSurf) {var SpringSurf = {};}\r\n");
        writer.write("SpringSurf.messages = SpringSurf.messages || {global: null, scope: {}}\r\n");
        writer.write("SpringSurf.messages.global = ");
        JSONWriter out = new JSONWriter((Writer)writer);
        try {
            out.startObject();
            Map messages = I18NUtil.getAllMessages((Locale)I18NUtil.parseLocale((String)locale));
            for (Map.Entry entry : messages.entrySet()) {
                out.writeValue((String)entry.getKey(), (String)entry.getValue());
            }
            out.endObject();
        }
        catch (IOException jsonErr) {
            throw new WebScriptException("Error building messages response.", (Throwable)jsonErr);
        }
        writer.write(";\r\n");
        return writer.toString();
    }
}

