/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptForm
extends ScriptBase {
    private final Map<String, FormBinding> bindings;
    private final RequestContext renderContext;
    private ModelObject object;

    public ScriptForm(RequestContext context, ModelObject object) {
        super(context);
        this.renderContext = context;
        this.object = object;
        this.bindings = new HashMap<String, FormBinding>(16, 1.0f);
    }

    protected ScriptableMap buildProperties() {
        return null;
    }

    public void bind(String title, Object value) {
        this.bind(title, value, null);
    }

    public FormBinding bind(String id, Object value, Object nullValue) {
        if (value == null) {
            value = nullValue;
        }
        FormBinding binding = new FormBinding(id, value);
        this.bindings.put(id, binding);
        return binding;
    }

    public FormBinding getBinding(String id) {
        return this.bindings.get(id);
    }

    public Object[] getBindings() {
        Object[] array = new Object[this.bindings.size()];
        int i = 0;
        for (String key : this.bindings.keySet()) {
            FormBinding binding = this.bindings.get(key);
            array[i] = binding;
            ++i;
        }
        return array;
    }

    public String[] getBindingIds() {
        return this.bindings.keySet().toArray(new String[this.bindings.keySet().size()]);
    }

    protected static String getPrefix(RequestContext context, ModelObject object) {
        return "form_" + object.getId() + "___";
    }

    protected static String prefix(RequestContext context, ModelObject object, String id) {
        return ScriptForm.getPrefix(context, object) + id;
    }

    protected static String unprefix(String prefixedId) {
        int x = prefixedId.indexOf("___");
        if (x > -1) {
            return prefixedId.substring(x + 3);
        }
        return null;
    }

    public class FormBinding
    implements Serializable {
        private String id;
        private Object value;

        public FormBinding(String id) {
            this.id = id;
        }

        public FormBinding(String id, Object value) {
            this(id);
            this.value = value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String getId() {
            return ScriptForm.prefix(ScriptForm.this.renderContext, ScriptForm.this.object, this.id);
        }
    }
}

