/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import org.springframework.extensions.surf.util.Content;
import org.springframework.util.FileCopyUtils;

public class InputStreamContent
implements Content,
Serializable {
    private static final long serialVersionUID = -7729633986840536282L;
    private InputStream stream;
    private String mimetype;
    private String encoding;
    private String content;

    public InputStreamContent(InputStream stream, String mimetype, String encoding) {
        this.stream = stream;
        this.mimetype = mimetype;
        this.encoding = encoding;
    }

    public String getContent() throws IOException {
        if (this.content == null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            FileCopyUtils.copy((InputStream)this.stream, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            String encoding = this.getEncoding();
            this.content = encoding == null ? new String(bytes) : new String(bytes, encoding);
        }
        return this.content;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public Reader getReader() throws IOException {
        return this.encoding == null ? new InputStreamReader(this.stream) : new InputStreamReader(this.stream, this.encoding);
    }

    public long getSize() {
        return -1L;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

