/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class AtomEntry
extends AtomDocumentBase {
    private static final String DEFAULT_AUTHOR = "unknown";

    public AtomEntry() {
    }

    public AtomEntry(XMLStreamWriter writer) {
        this.setWriter(writer);
    }

    public void startEntry(boolean isRoot) throws XMLStreamException {
        this.getWriter().writeStartElement("http://www.w3.org/2005/Atom", "entry");
        if (isRoot) {
            this.writeNamespace("http://www.w3.org/2005/Atom");
            this.writeNamespace("http://docs.oasis-open.org/ns/cmis/core/200908/");
            this.writeNamespace("http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            this.writeNamespace("http://www.w3.org/2007/app");
        }
    }

    public void endEntry() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeObject(ObjectData object, ObjectInfo info, String contentSrc, String contentType, String pathSegment, String relativePathSegment) throws XMLStreamException, JAXBException {
        CmisObjectType objectJaxb = Converter.convert((ObjectData)object);
        if (objectJaxb == null) {
            return;
        }
        this.writeAuthor(info.getCreatedBy());
        this.writeId(this.generateAtomId(info.getId()));
        this.writePublished(info.getCreationDate());
        this.writeTitle(info.getName());
        this.writeUpdated(info.getLastModificationDate());
        this.writeContent(contentSrc, contentType);
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(objectJaxb), (XMLStreamWriter)this.getWriter(), (boolean)true);
        this.writePathSegment(pathSegment);
        this.writeRelativePathSegment(relativePathSegment);
    }

    public void writeDeletedObject(ObjectData object) throws XMLStreamException, JAXBException {
        CmisObjectType objectJaxb = Converter.convert((ObjectData)object);
        if (objectJaxb == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.writeAuthor(DEFAULT_AUTHOR);
        this.writeId(this.generateAtomId(object.getId()));
        this.writePublished(now);
        this.writeTitle(object.getId());
        this.writeUpdated(now);
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(objectJaxb), (XMLStreamWriter)this.getWriter(), (boolean)true);
    }

    public void writeType(TypeDefinition type) throws XMLStreamException, JAXBException {
        CmisTypeDefinitionType typeJaxb = Converter.convert((TypeDefinition)type);
        if (typeJaxb == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.writeAuthor(DEFAULT_AUTHOR);
        this.writeId(this.generateAtomId(type.getId()));
        this.writeTitle(type.getDisplayName());
        this.writeUpdated(now);
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createTypeDefinition(typeJaxb), (XMLStreamWriter)this.getWriter(), (boolean)true);
    }

    public void writeContent(String src, String type) throws XMLStreamException {
        if (src == null) {
            return;
        }
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2005/Atom", "content");
        xsw.writeAttribute("src", src);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        xsw.writeEndElement();
    }
}

