/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserBindingUtils {
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String ROOT_PATH_FRAGMENT = "root";
    public static final String PARAM_SELECTOR = "selector";
    public static final String PARAM_TRANSACTION = "transaction";
    public static final String PARAM_CLIENT_TOKEN = "clientToken";
    public static final String PARAM_SUPPRESS_RESPONSE_CODES = "suppressResponseCodes";
    public static final String CONTROL_CMISACTION = "cmisaction";
    public static final String CONTROL_TRANSACTION = "transaction";
    public static final String CONTROL_OBJECT_ID = "objectid";
    public static final String CONTROL_PROP_ID = "propertyid";
    public static final String CONTROL_PROP_VALUE = "propertyvalue";
    public static final String CONTROL_POLICY = "policy";
    public static final String CONTROL_ADD_ACE_PRINCIPAL = "addACEPrincipal";
    public static final String CONTROL_ADD_ACE_PERMISSION = "addACEPermission";
    public static final String CONTROL_REMOVE_ACE_PRINCIPAL = "removeACEPrincipal";
    public static final String CONTROL_REMOVE_ACE_PERMISSION = "removeACEPermission";
    public static final String CONTROL_CONTENT_TYPE = "contenttype";
    public static final String CONTROL_FILENAME = "filename";
    public static final String CONTEXT_OBJECT_ID = "org.apache.chemistry.opencmis.browserbinding.objectId";
    public static final String CONTEXT_OBJECT_TYPE_ID = "org.apache.chemistry.opencmis.browserbinding.objectTypeId";
    public static final String CONTEXT_BASETYPE_ID = "org.apache.chemistry.opencmis.browserbinding.basetypeId";
    public static final String CONTEXT_TRANSACTION = "org.apache.chemistry.opencmis.browserbinding.transaction";

    private BrowserBindingUtils() {
    }

    public static UrlBuilder compileBaseUrl(HttpServletRequest request) {
        UrlBuilder url = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
        url.addPath(request.getContextPath());
        url.addPath(request.getServletPath());
        return url;
    }

    public static UrlBuilder compileRepositoryUrl(HttpServletRequest request, String repositoryId) {
        return BrowserBindingUtils.compileBaseUrl(request).addPathSegment(repositoryId);
    }

    public static UrlBuilder compileRootUrl(HttpServletRequest request, String repositoryId) {
        return BrowserBindingUtils.compileRepositoryUrl(request, repositoryId).addPathSegment(ROOT_PATH_FRAGMENT);
    }

    public static String getPath(HttpServletRequest request) {
        String[] pathFragments = HttpUtils.splitPath(request);
        if (pathFragments.length < 2) {
            return null;
        }
        if (pathFragments.length == 2) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < pathFragments.length; ++i) {
            if (pathFragments[i].length() == 0) continue;
            sb.append("/");
            sb.append(pathFragments[i]);
        }
        return sb.toString();
    }

    public static void prepareContext(CallContext context, CallUrl callUrl, CmisService service, String repositoryId, String objectId, String transaction, HttpServletRequest request) {
        CallContextImpl contextImpl = null;
        if (context instanceof CallContextImpl) {
            contextImpl = (CallContextImpl)context;
            contextImpl.put(CONTEXT_TRANSACTION, transaction);
        }
        if (callUrl != CallUrl.ROOT) {
            return;
        }
        ObjectData object = null;
        object = objectId != null ? service.getObject(repositoryId, objectId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null) : service.getObjectByPath(repositoryId, BrowserBindingUtils.getPath(request), "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
        if (contextImpl != null) {
            contextImpl.put(CONTEXT_OBJECT_ID, object.getId());
            contextImpl.put(CONTEXT_OBJECT_TYPE_ID, BrowserBindingUtils.getProperty(object, "cmis:objectTypeId", String.class));
            contextImpl.put(CONTEXT_BASETYPE_ID, BrowserBindingUtils.getProperty(object, "cmis:baseTypeId", String.class));
        }
    }

    public static <T> T getProperty(ObjectData object, String name, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Properties propData = object.getProperties();
        if (propData == null) {
            return null;
        }
        Map properties = propData.getProperties();
        if (properties == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.get(name);
        if (property == null) {
            return null;
        }
        Object value = property.getFirstValue();
        if (!clazz.isInstance(value)) {
            return null;
        }
        return (T)value;
    }

    public static Properties createProperties(ControlParser controlParser, String typeId, TypeCache typeCache) {
        TypeDefinition typeDef;
        List<String> propertyIds = controlParser.getValues(CONTROL_PROP_ID);
        if (propertyIds == null) {
            return null;
        }
        Map<Integer, String> singleValuePropertyMap = controlParser.getOneDimMap(CONTROL_PROP_VALUE);
        Map<Integer, Map<Integer, String>> multiValuePropertyMap = controlParser.getTwoDimMap(CONTROL_PROP_VALUE);
        if (typeId == null) {
            int i = 0;
            for (String propertId : propertyIds) {
                if ("cmis:objectTypeId".equals(propertId)) {
                    typeId = singleValuePropertyMap.get(i);
                    break;
                }
                ++i;
            }
            if (typeId == null) {
                throw new CmisInvalidArgumentException("cmis:objectTypeId not set!");
            }
        }
        if ((typeDef = typeCache.getTypeDefinition(typeId)) == null) {
            throw new CmisInvalidArgumentException("Invalid type: " + typeId);
        }
        PropertiesImpl result = new PropertiesImpl();
        int i = 0;
        for (String propertyId : propertyIds) {
            PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(propertyId);
            if (propDef == null) {
                throw new CmisInvalidArgumentException(propertyId + " is unknown!");
            }
            PropertyData<?> propertyData = null;
            propertyData = singleValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, singleValuePropertyMap.get(i)) : (multiValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, controlParser.getValues(CONTROL_PROP_VALUE, i)) : BrowserBindingUtils.createPropertyData(propDef, null));
            result.addProperty(propertyData);
            ++i;
        }
        return result;
    }

    private static PropertyData<?> createPropertyData(PropertyDefinition<?> propDef, Object value) {
        ArrayList<String> strValues;
        if (value == null) {
            strValues = Collections.emptyList();
        } else if (value instanceof String) {
            strValues = new ArrayList<String>();
            strValues.add((String)value);
        } else {
            strValues = (ArrayList<String>)value;
        }
        PropertyStringImpl propertyData = null;
        switch (propDef.getPropertyType()) {
            case STRING: {
                propertyData = new PropertyStringImpl(propDef.getId(), strValues);
                break;
            }
            case ID: {
                propertyData = new PropertyIdImpl(propDef.getId(), strValues);
                break;
            }
            case BOOLEAN: {
                ArrayList<Boolean> boolValues = new ArrayList<Boolean>(strValues.size());
                try {
                    for (String s : strValues) {
                        boolValues.add(Boolean.valueOf(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not a boolean value!");
                }
                propertyData = new PropertyBooleanImpl(propDef.getId(), boolValues);
                break;
            }
            case INTEGER: {
                ArrayList<BigInteger> intValues = new ArrayList<BigInteger>(strValues.size());
                try {
                    for (String s : strValues) {
                        intValues.add(new BigInteger(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!");
                }
                propertyData = new PropertyIntegerImpl(propDef.getId(), intValues);
                break;
            }
            case DECIMAL: {
                ArrayList<BigDecimal> decValues = new ArrayList<BigDecimal>(strValues.size());
                try {
                    for (String s : strValues) {
                        decValues.add(new BigDecimal(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!");
                }
                propertyData = new PropertyDecimalImpl(propDef.getId(), decValues);
                break;
            }
            case DATETIME: {
                ArrayList<GregorianCalendar> calValues = new ArrayList<GregorianCalendar>(strValues.size());
                try {
                    for (String s : strValues) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(Long.parseLong(s));
                        calValues.add(cal);
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an datetime value!");
                }
                propertyData = new PropertyDateTimeImpl(propDef.getId(), calValues);
                break;
            }
            case HTML: {
                propertyData = new PropertyHtmlImpl(propDef.getId(), strValues);
                break;
            }
            case URI: {
                propertyData = new PropertyUriImpl(propDef.getId(), strValues);
            }
        }
        return propertyData;
    }

    public static List<String> createPolicies(ControlParser controlParser) {
        return controlParser.getValues(CONTROL_POLICY);
    }

    public static Acl createAddAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues(CONTROL_ADD_ACE_PRINCIPAL);
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues(CONTROL_ADD_ACE_PERMISSION, i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public static Acl createRemoveAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues(CONTROL_REMOVE_ACE_PRINCIPAL);
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues(CONTROL_REMOVE_ACE_PERMISSION, i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public static ContentStream createContentStream(HttpServletRequest request) {
        ContentStreamImpl result = null;
        if (request instanceof POSTHttpServletRequestWrapper) {
            POSTHttpServletRequestWrapper post = (POSTHttpServletRequestWrapper)request;
            result = new ContentStreamImpl(post.getFilename(), BigInteger.valueOf(post.getSize()), post.getContentType(), post.getStream());
        }
        return result;
    }

    protected static ObjectData getSimpleObject(CmisService service, String repositoryId, String objectId) {
        return service.getObject(repositoryId, objectId, null, Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public static String getCookieName(String transaction) {
        if (transaction == null || transaction.length() == 0) {
            return "cmis%";
        }
        return "cmis_" + Base64.encodeBytes((byte[])transaction.getBytes()).replace('=', '%');
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String transaction, String value) {
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, value, 3600);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String transaction) {
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, "", 0);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String transaction, String value, int expiry) {
        if (transaction != null && transaction.length() > 0) {
            Cookie transactionCookie = new Cookie(BrowserBindingUtils.getCookieName(transaction), value);
            transactionCookie.setMaxAge(expiry);
            transactionCookie.setPath(request.getContextPath() + request.getServletPath() + "/" + repositoryId);
            response.addCookie(transactionCookie);
        }
    }

    public static String createCookieValue(int code, String objectId, String ex, String message) {
        JSONObject result = new JSONObject();
        result.put((Object)"code", (Object)code);
        result.put((Object)"objectId", (Object)(objectId == null ? "" : objectId));
        result.put((Object)"exception", (Object)(ex == null ? "" : ex));
        result.put((Object)"message", (Object)(message == null ? "" : message));
        return result.toJSONString();
    }

    public static void writeJSON(JSONStreamAware json, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(JSON_MIME_TYPE);
        response.setCharacterEncoding("UTF-8");
        String clientToken = HttpUtils.getStringParameter(request, PARAM_CLIENT_TOKEN);
        if (clientToken != null) {
            if (!clientToken.matches("[A-Za-z0-9._\\[\\]]*")) {
                throw new CmisInvalidArgumentException("Invalid clientToken name!");
            }
            response.getWriter().print(clientToken + "(");
        }
        json.writeJSONString((Writer)response.getWriter());
        if (clientToken != null) {
            response.getWriter().print(");");
        }
    }

    public static void writeEmpty(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentLength(0);
        response.setContentType("text/plain");
        response.getWriter().flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CallUrl {
        SERVICE,
        REPOSITORY,
        ROOT;

    }
}

