/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.impl.browser.AclService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.DiscoveryService;
import org.apache.chemistry.opencmis.server.impl.browser.MultiFilingService;
import org.apache.chemistry.opencmis.server.impl.browser.NavigationService;
import org.apache.chemistry.opencmis.server.impl.browser.ObjectService;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.impl.browser.PolicyService;
import org.apache.chemistry.opencmis.server.impl.browser.RelationshipService;
import org.apache.chemistry.opencmis.server.impl.browser.RepositoryService;
import org.apache.chemistry.opencmis.server.impl.browser.VersioningService;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;
import org.apache.chemistry.opencmis.server.shared.Dispatcher;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class CmisBrowserBindingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_CALL_CONTEXT_HANDLER = "callContextHandler";
    private static final Log LOG = LogFactory.getLog((String)CmisBrowserBindingServlet.class.getName());
    private Dispatcher repositoryDispatcher;
    private Dispatcher rootDispatcher;
    private CallContextHandler callContextHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.callContextHandler = null;
        String callContextHandlerClass = config.getInitParameter(PARAM_CALL_CONTEXT_HANDLER);
        if (callContextHandlerClass != null) {
            try {
                this.callContextHandler = (CallContextHandler)Class.forName(callContextHandlerClass).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not load call context handler: " + e, (Throwable)e);
            }
        }
        this.repositoryDispatcher = new Dispatcher();
        this.rootDispatcher = new Dispatcher();
        try {
            this.repositoryDispatcher.addResource("", "GET", RepositoryService.class, "getRepositoryInfo");
            this.repositoryDispatcher.addResource("lastResult", "GET", RepositoryService.class, "getLastResult");
            this.repositoryDispatcher.addResource("typeChildren", "GET", RepositoryService.class, "getTypeChildren");
            this.repositoryDispatcher.addResource("typeDescendants", "GET", RepositoryService.class, "getTypeDescendants");
            this.repositoryDispatcher.addResource("typeDefinition", "GET", RepositoryService.class, "getTypeDefinition");
            this.repositoryDispatcher.addResource("query", "GET", DiscoveryService.class, "query");
            this.repositoryDispatcher.addResource("checkedout", "GET", NavigationService.class, "getCheckedOutDocs");
            this.repositoryDispatcher.addResource("contentChanges", "GET", DiscoveryService.class, "getContentChanges");
            this.repositoryDispatcher.addResource("query", "POST", DiscoveryService.class, "query");
            this.repositoryDispatcher.addResource("createDocument", "POST", ObjectService.class, "createDocument");
            this.repositoryDispatcher.addResource("createDocumentFromSource", "POST", ObjectService.class, "createDocumentFromSource");
            this.repositoryDispatcher.addResource("createPolicy", "POST", ObjectService.class, "createPolicy");
            this.repositoryDispatcher.addResource("createRelationship", "POST", ObjectService.class, "createRelationship");
            this.rootDispatcher.addResource("object", "GET", ObjectService.class, "getObject");
            this.rootDispatcher.addResource("properties", "GET", ObjectService.class, "getProperties");
            this.rootDispatcher.addResource("renditions", "GET", ObjectService.class, "getRenditions");
            this.rootDispatcher.addResource("content", "GET", ObjectService.class, "getContentStream");
            this.rootDispatcher.addResource("children", "GET", NavigationService.class, "getChildren");
            this.rootDispatcher.addResource("descendants", "GET", NavigationService.class, "getDescendants");
            this.rootDispatcher.addResource("folder", "GET", NavigationService.class, "getFolderTree");
            this.rootDispatcher.addResource("parent", "GET", NavigationService.class, "getFolderParent");
            this.rootDispatcher.addResource("parents", "GET", NavigationService.class, "getObjectParents");
            this.rootDispatcher.addResource("versions", "GET", VersioningService.class, "getAllVersions");
            this.rootDispatcher.addResource("relationships", "GET", RelationshipService.class, "getObjectRelationships");
            this.rootDispatcher.addResource("checkedout", "GET", NavigationService.class, "getCheckedOutDocs");
            this.rootDispatcher.addResource("policies", "GET", PolicyService.class, "getAppliedPolicies");
            this.rootDispatcher.addResource("acl", "GET", AclService.class, "getACL");
            this.rootDispatcher.addResource("createDocument", "POST", ObjectService.class, "createDocument");
            this.rootDispatcher.addResource("createDocumentFromSource", "POST", ObjectService.class, "createDocumentFromSource");
            this.rootDispatcher.addResource("createFolder", "POST", ObjectService.class, "createFolder");
            this.rootDispatcher.addResource("createPolicy", "POST", ObjectService.class, "createPolicy");
            this.rootDispatcher.addResource("setContent", "POST", ObjectService.class, "setContentStream");
            this.rootDispatcher.addResource("deleteContent", "POST", ObjectService.class, "deleteContentStream");
            this.rootDispatcher.addResource("delete", "POST", ObjectService.class, "deleteObject");
            this.rootDispatcher.addResource("deleteTree", "POST", ObjectService.class, "deleteTree");
            this.rootDispatcher.addResource("move", "POST", ObjectService.class, "moveObject");
            this.rootDispatcher.addResource("addObjectToFolder", "POST", MultiFilingService.class, "addObjectToFolder");
            this.rootDispatcher.addResource("removeObjectFromFolder", "POST", MultiFilingService.class, "removeObjectFromFolder");
            this.rootDispatcher.addResource("checkOut", "POST", VersioningService.class, "checkOut");
            this.rootDispatcher.addResource("cancelCheckOut", "POST", VersioningService.class, "cancelCheckOut");
            this.rootDispatcher.addResource("checkIn", "POST", VersioningService.class, "checkIn");
            this.rootDispatcher.addResource("applyPolicy", "POST", PolicyService.class, "applyPolicy");
            this.rootDispatcher.addResource("removePolicy", "POST", PolicyService.class, "removePolicy");
            this.rootDispatcher.addResource("applyACL", "POST", AclService.class, "applyACL");
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Cannot initialize dispatcher!", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader("Cache-Control", "private, max-age=0");
        response.addHeader("Server", ServerVersion.OPENCMIS_SERVER);
        CallContext context = null;
        try {
            context = HttpUtils.createContext(request, response, this.getServletContext(), "browser", this.callContextHandler);
            this.dispatch(context, request, response);
        }
        catch (Exception e) {
            if (e instanceof CmisPermissionDeniedException) {
                if (context == null || context.getUsername() == null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\"");
                    response.sendError(401, "Authorization Required");
                } else {
                    CmisBrowserBindingServlet.printError(e, request, response, context);
                }
            }
            CmisBrowserBindingServlet.printError(e, request, response, context);
        }
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(CallContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CmisService service = null;
        try {
            CmisServiceFactory factory = (CmisServiceFactory)this.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
            if (factory == null) {
                throw new CmisRuntimeException("Service factory not available! Configuration problem?");
            }
            service = factory.getService(context);
            String[] pathFragments = HttpUtils.splitPath(request);
            if (pathFragments.length < 1) {
                RepositoryService.getRepositories(context, service, request, response);
                return;
            }
            BrowserBindingUtils.CallUrl callUrl = null;
            if (pathFragments.length == 1) {
                callUrl = BrowserBindingUtils.CallUrl.REPOSITORY;
            } else if ("root".equals(pathFragments[1])) {
                callUrl = BrowserBindingUtils.CallUrl.ROOT;
            }
            if (callUrl == null) {
                throw new CmisNotSupportedException("Unknown operation");
            }
            String method = request.getMethod();
            String repositoryId = pathFragments[0];
            boolean methodFound = false;
            if ("GET".equals(method)) {
                String selector = HttpUtils.getStringParameter(request, "selector");
                String objectId = HttpUtils.getStringParameter(request, "objectId");
                BrowserBindingUtils.prepareContext(context, callUrl, service, repositoryId, objectId, null, request);
                if (callUrl == BrowserBindingUtils.CallUrl.REPOSITORY) {
                    if (selector == null) {
                        selector = "";
                    }
                    methodFound = this.repositoryDispatcher.dispatch(selector, method, context, service, repositoryId, request, response);
                } else if (callUrl == BrowserBindingUtils.CallUrl.ROOT) {
                    if (selector == null) {
                        try {
                            BaseTypeId basetype = BaseTypeId.fromValue((String)((String)context.get("org.apache.chemistry.opencmis.browserbinding.basetypeId")));
                            switch (basetype) {
                                case CMIS_DOCUMENT: {
                                    selector = "content";
                                    break;
                                }
                                case CMIS_FOLDER: {
                                    selector = "children";
                                    break;
                                }
                                default: {
                                    selector = "object";
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            selector = "object";
                        }
                    }
                    methodFound = this.rootDispatcher.dispatch(selector, method, context, service, repositoryId, request, response);
                }
            } else if ("POST".equals(method)) {
                POSTHttpServletRequestWrapper postRequest = new POSTHttpServletRequestWrapper(request);
                String cmisaction = HttpUtils.getStringParameter((HttpServletRequest)postRequest, "cmisaction");
                String objectId = HttpUtils.getStringParameter((HttpServletRequest)postRequest, "objectid");
                String transaction = HttpUtils.getStringParameter((HttpServletRequest)postRequest, "transaction");
                if (cmisaction == null || cmisaction.length() == 0) {
                    throw new CmisNotSupportedException("Unknown action");
                }
                BrowserBindingUtils.prepareContext(context, callUrl, service, repositoryId, objectId, transaction, (HttpServletRequest)postRequest);
                if (callUrl == BrowserBindingUtils.CallUrl.REPOSITORY) {
                    methodFound = this.repositoryDispatcher.dispatch(cmisaction, method, context, service, repositoryId, (HttpServletRequest)postRequest, response);
                } else if (callUrl == BrowserBindingUtils.CallUrl.ROOT) {
                    methodFound = this.rootDispatcher.dispatch(cmisaction, method, context, service, repositoryId, (HttpServletRequest)postRequest, response);
                }
            }
            if (!methodFound) {
                throw new CmisNotSupportedException("Unknown operation");
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    private static int getErrorCode(CmisBaseException ex) {
        if (ex instanceof CmisConstraintException) {
            return 409;
        }
        if (ex instanceof CmisContentAlreadyExistsException) {
            return 409;
        }
        if (ex instanceof CmisFilterNotValidException) {
            return 400;
        }
        if (ex instanceof CmisInvalidArgumentException) {
            return 400;
        }
        if (ex instanceof CmisNameConstraintViolationException) {
            return 409;
        }
        if (ex instanceof CmisNotSupportedException) {
            return 405;
        }
        if (ex instanceof CmisObjectNotFoundException) {
            return 404;
        }
        if (ex instanceof CmisPermissionDeniedException) {
            return 403;
        }
        if (ex instanceof CmisStorageException) {
            return 500;
        }
        if (ex instanceof CmisStreamNotSupportedException) {
            return 403;
        }
        if (ex instanceof CmisUpdateConflictException) {
            return 409;
        }
        if (ex instanceof CmisVersioningException) {
            return 409;
        }
        return 500;
    }

    private static void printError(Exception ex, HttpServletRequest request, HttpServletResponse response, CallContext context) {
        int statusCode = 500;
        String exceptionName = "runtime";
        if (ex instanceof CmisRuntimeException) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        } else if (ex instanceof CmisBaseException) {
            statusCode = CmisBrowserBindingServlet.getErrorCode((CmisBaseException)ex);
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        } else {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (HttpUtils.getBooleanParameter(request, "suppressResponseCodes", false)) {
            statusCode = 200;
        }
        response.setStatus(statusCode);
        response.setContentType("application/json");
        if (context != null) {
            BrowserBindingUtils.setCookie(request, response, context.getRepositoryId(), (String)context.get("org.apache.chemistry.opencmis.browserbinding.transaction"), BrowserBindingUtils.createCookieValue(statusCode, null, exceptionName, ex.getMessage()));
        }
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"exception", (Object)exceptionName);
        jsonResponse.put((Object)"message", (Object)ex.getMessage());
        String st = ExceptionHelper.getStacktraceAsString(ex);
        if (st != null) {
            jsonResponse.put((Object)"stacktrace", (Object)st);
        }
        try {
            BrowserBindingUtils.writeJSON((JSONStreamAware)jsonResponse, request, response);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

