/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    private ObjectService() {
    }

    public static void createDocument(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createDocument(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createContentStream(request), versioningState, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New document is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createDocumentFromSource(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String sourceId = HttpUtils.getStringParameter(request, "sourceId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createDocumentFromSource(repositoryId, sourceId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, versioningState, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New document is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createFolder(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New folder is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createPolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createPolicy(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New policy is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createRelationship(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        String newObjectId = service.createRelationship(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New relationship is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void updateProperties(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String typeId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectTypeId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        ControlParser cp = new ControlParser(request);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.updateProperties(repositoryId, objectIdHolder, changeTokenHolder, BrowserBindingUtils.createProperties(cp, typeId, typeCache), null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        int status = 200;
        if (!objectId.equals(newObjectId)) {
            status = 201;
        }
        response.setStatus(status);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(status, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getProperties(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        Properties properties = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getPropertiesOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, null) : service.getProperties(repositoryId, objectId, filter, null);
        if (properties == null) {
            throw new CmisRuntimeException("Properties are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((Properties)properties, (String)objectId, (TypeCache)typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        ObjectData object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getRenditions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        List renditions = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, null);
        JSONArray jsonRenditions = new JSONArray();
        if (renditions != null) {
            for (RenditionData rendition : renditions) {
                jsonRenditions.add((Object)JSONConverter.convert((RenditionData)rendition));
            }
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonRenditions, request, response);
    }

    public static void getContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int b;
        BigInteger length;
        BigInteger offset;
        String streamId;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ContentStream content = service.getContentStream(repositoryId, objectId, streamId = HttpUtils.getStringParameter(request, "streamId"), offset = context.getOffset(), length = context.getLength(), null);
        if (content == null || content.getStream() == null) {
            throw new CmisRuntimeException("Content stream is null!");
        }
        String contentType = content.getMimeType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (offset == null && length == null) {
            response.setStatus(200);
        } else {
            response.setStatus(206);
        }
        response.setContentType(contentType);
        BufferedInputStream in = new BufferedInputStream(content.getStream(), 65536);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] buffer = new byte[65536];
        while ((b = ((InputStream)in).read(buffer)) > -1) {
            ((OutputStream)out).write(buffer, 0, b);
        }
        ((InputStream)in).close();
        ((OutputStream)out).flush();
    }

    public static void deleteObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        Boolean allVersions = HttpUtils.getBooleanParameter(request, "allVersions");
        service.deleteObject(repositoryId, objectId, allVersions, null);
        response.setStatus(200);
        BrowserBindingUtils.writeEmpty(request, response);
    }

    public static void deleteTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean continueOnFailure;
        UnfileObject unfileObjects;
        Boolean allVersions;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        FailedToDeleteData ftd = service.deleteTree(repositoryId, objectId, allVersions = HttpUtils.getBooleanParameter(request, "allVersions"), unfileObjects = HttpUtils.getEnumParameter(request, "unfileObjects", UnfileObject.class), continueOnFailure = HttpUtils.getBooleanParameter(request, "continueOnFailure"), null);
        if (ftd == null || ftd.getIds() == null || ftd.getIds().size() > 0) {
            // empty if block
        }
        response.setStatus(200);
        BrowserBindingUtils.writeEmpty(request, response);
    }

    public static void deleteContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.deleteContentStream(repositoryId, objectIdHolder, changeTokenHolder, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        response.setStatus(200);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void setContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        Boolean overwriteFlag = HttpUtils.getBooleanParameter(request, "overwriteFlag");
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeTokenHolder, BrowserBindingUtils.createContentStream(request), null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        response.setStatus(201);
        response.setHeader("Location", location);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void moveObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String targetFolderId = HttpUtils.getStringParameter(request, "targetFolderId");
        String sourceFolderId = HttpUtils.getStringParameter(request, "sourceFolderId");
        Holder objectIdHolder = new Holder((Object)objectId);
        service.moveObject(repositoryId, objectIdHolder, targetFolderId, sourceFolderId, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        response.setStatus(201);
        response.setHeader("Location", location);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }
}

