/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISActionEvaluator;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.opencmis.dictionary.CMISPropertyLuceneBuilder;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.search.impl.lucene.analysis.DateAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.DoubleAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.FloatAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.IntegerAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.LongAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.PathAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.abdera.ext.utils.ISO8601DateFormat;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeDefinitionWrapper
implements TypeDefinitionWrapper,
Serializable {
    private static final long serialVersionUID = 1L;
    protected AbstractTypeDefinition typeDef;
    protected AbstractTypeDefinition typeDefInclProperties;
    protected TypeDefinitionWrapper parent;
    protected List<TypeDefinitionWrapper> children;
    protected QName alfrescoName = null;
    protected QName alfrescoClass = null;
    protected Map<Action, CMISActionEvaluator> actionEvaluators;
    protected Map<String, PropertyDefinitionWrapper> propertiesById = new HashMap<String, PropertyDefinitionWrapper>();
    protected Map<String, PropertyDefinitionWrapper> propertiesByQueryName = new HashMap<String, PropertyDefinitionWrapper>();
    protected Map<QName, PropertyDefinitionWrapper> propertiesByQName = new HashMap<QName, PropertyDefinitionWrapper>();

    @Override
    public TypeDefinition getTypeDefinition(boolean includePropertyDefinitions) {
        if (includePropertyDefinitions) {
            return this.typeDefInclProperties;
        }
        return this.typeDef;
    }

    protected void setTypeDefinition(AbstractTypeDefinition typeDef, AbstractTypeDefinition typeDefInclProperties) {
        this.typeDef = typeDef;
        this.typeDefInclProperties = typeDefInclProperties;
    }

    @Override
    public String getTypeId() {
        return this.typeDef.getId();
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        return this.typeDef.getBaseTypeId();
    }

    @Override
    public boolean isBaseType() {
        return this.typeDef.getId().equals(this.typeDef.getBaseTypeId().value());
    }

    @Override
    public QName getAlfrescoName() {
        return this.alfrescoName;
    }

    @Override
    public QName getAlfrescoClass() {
        return this.alfrescoClass;
    }

    @Override
    public TypeDefinitionWrapper getParent() {
        return this.parent;
    }

    @Override
    public List<TypeDefinitionWrapper> getChildren() {
        return this.children;
    }

    @Override
    public Map<Action, CMISActionEvaluator> getActionEvaluators() {
        return this.actionEvaluators;
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties() {
        return this.propertiesById.values();
    }

    @Override
    public PropertyDefinitionWrapper getPropertyById(String propertyId) {
        return this.propertiesById.get(propertyId);
    }

    @Override
    public PropertyDefinitionWrapper getPropertyByQueryName(String queryName) {
        return this.propertiesByQueryName.get(queryName);
    }

    @Override
    public PropertyDefinitionWrapper getPropertyByQName(QName name) {
        return this.propertiesByQName.get(name);
    }

    public abstract void connectParentAndSubTypes(CMISMapping var1, CMISAbstractDictionaryService.DictionaryRegistry var2, DictionaryService var3);

    public abstract void resolveInheritance(CMISMapping var1, CMISAbstractDictionaryService.DictionaryRegistry var2, DictionaryService var3);

    public void assertComplete() {
        if (this.typeDef == null) {
            throw new IllegalStateException("typeDef is not set");
        }
        if (this.typeDefInclProperties == null) {
            throw new IllegalStateException("typeDefInclProperties is not set");
        }
        if (this.alfrescoName == null) {
            throw new IllegalStateException("alfrescoName is not set");
        }
        if (this.alfrescoClass == null) {
            throw new IllegalStateException("alfrescoClass is not set");
        }
        if (this.propertiesById == null) {
            throw new IllegalStateException("propertiesById is not set");
        }
        if (this.propertiesByQueryName == null) {
            throw new IllegalStateException("propertiesByQueryName is not set");
        }
        if (this.propertiesByQName == null) {
            throw new IllegalStateException("propertiesByQName is not set");
        }
        if (this.propertiesById.size() == 0) {
            throw new IllegalStateException("property map empty");
        }
        if (this.propertiesById.size() != this.propertiesByQueryName.size()) {
            throw new IllegalStateException("property map mismatch");
        }
        if (this.propertiesById.size() != this.propertiesByQName.size()) {
            throw new IllegalStateException("property map mismatch");
        }
    }

    protected void createOwningPropertyDefinitions(CMISMapping cmisMapping, PropertyAccessorMapping propertyAccessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, ClassDefinition cmisClassDef) {
        for (org.alfresco.service.cmr.dictionary.PropertyDefinition alfrescoPropDef : cmisClassDef.getProperties().values()) {
            String propertyId;
            PropertyDefinition<?> propertyDefintion;
            if (!this.isBaseType() && !alfrescoPropDef.getContainerClass().equals(cmisClassDef) || (propertyDefintion = this.createPropertyDefinition(cmisMapping, propertyId = cmisMapping.buildPrefixEncodedString(alfrescoPropDef.getName()), alfrescoPropDef.getName(), alfrescoPropDef, false)) == null) continue;
            CMISPropertyAccessor propertyAccessor = null;
            if (propertyAccessorMapping != null && (propertyAccessor = propertyAccessorMapping.getPropertyAccessor(propertyId)) == null) {
                propertyAccessor = propertyAccessorMapping.createDirectPropertyAccessor(propertyId, alfrescoPropDef.getName());
            }
            CMISPropertyLuceneBuilder luceneBuilder = null;
            if (luceneBuilderMapping != null && (luceneBuilder = luceneBuilderMapping.getPropertyLuceneBuilder(propertyId)) == null) {
                luceneBuilder = luceneBuilderMapping.createDirectPropertyLuceneBuilder(alfrescoPropDef.getName());
            }
            this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), this, propertyAccessor, luceneBuilder));
        }
    }

    protected void registerProperty(PropertyDefinitionWrapper propDefWrapper) {
        if (propDefWrapper == null) {
            return;
        }
        if (this.propertiesById.containsKey(propDefWrapper.getPropertyId())) {
            throw new AlfrescoRuntimeException("Property defintion " + propDefWrapper.getPropertyId() + " already exists on type " + this.typeDef.getId());
        }
        this.propertiesById.put(propDefWrapper.getPropertyId(), propDefWrapper);
        this.propertiesByQueryName.put(propDefWrapper.getPropertyDefinition().getQueryName(), propDefWrapper);
        this.propertiesByQName.put(propDefWrapper.getAlfrescoName(), propDefWrapper);
        this.typeDefInclProperties.addPropertyDefinition(propDefWrapper.getPropertyDefinition());
    }

    protected PropertyDefinition<?> createPropertyDefinition(CMISMapping cmisMapping, String id, QName alfrescoPropName, org.alfresco.service.cmr.dictionary.PropertyDefinition propDef, boolean inherited) {
        PropertyType datatype = cmisMapping.getDataType(propDef.getDataType());
        if (datatype == null) {
            return null;
        }
        PropertyBooleanDefinitionImpl result = null;
        switch (datatype) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        if (id.equals("cmis:objectTypeId") || id.equals("cmis:sourceId") || id.equals("cmis:targetId")) {
            result.setUpdatability(Updatability.ONCREATE);
        } else {
            result.setUpdatability(propDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE);
        }
        result.setId(id);
        result.setLocalName(alfrescoPropName.getLocalName());
        result.setLocalNamespace(alfrescoPropName.getNamespaceURI());
        result.setDisplayName(propDef.getTitle() != null ? propDef.getTitle() : id);
        result.setDescription(propDef.getDescription() != null ? propDef.getDescription() : result.getDisplayName());
        result.setPropertyType(datatype);
        result.setCardinality(propDef.isMultiValued() ? Cardinality.MULTI : Cardinality.SINGLE);
        result.setIsInherited(Boolean.valueOf(inherited));
        result.setIsRequired(Boolean.valueOf(propDef.isMandatory()));
        this.addDefaultValue(propDef.getDefaultValue(), (PropertyDefinition<?>)result);
        result.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(alfrescoPropName)));
        result.setIsQueryable(Boolean.valueOf(propDef.isIndexed()));
        result.setIsOrderable(Boolean.valueOf(false));
        if (result.isQueryable().booleanValue() && result.getCardinality() == Cardinality.SINGLE) {
            IndexTokenisationMode indexTokenisationMode = IndexTokenisationMode.TRUE;
            if (propDef.getIndexTokenisationMode() != null) {
                indexTokenisationMode = propDef.getIndexTokenisationMode();
            }
            switch (indexTokenisationMode) {
                case BOTH: 
                case FALSE: {
                    result.setIsOrderable(Boolean.valueOf(true));
                    break;
                }
                default: {
                    String analyserClassName = propDef.resolveAnalyserClassName();
                    if (propDef.getDataType().getName().equals(DataTypeDefinition.BOOLEAN)) {
                        result.setIsOrderable(Boolean.valueOf(true));
                        break;
                    }
                    if (!analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName()) && !analyserClassName.equals(DateAnalyser.class.getCanonicalName()) && !analyserClassName.equals(DoubleAnalyser.class.getCanonicalName()) && !analyserClassName.equals(FloatAnalyser.class.getCanonicalName()) && !analyserClassName.equals(IntegerAnalyser.class.getCanonicalName()) && !analyserClassName.equals(LongAnalyser.class.getCanonicalName()) && !analyserClassName.equals(PathAnalyser.class.getCanonicalName()) && !analyserClassName.equals(VerbatimAnalyser.class.getCanonicalName())) break;
                    result.setIsOrderable(Boolean.valueOf(true));
                }
            }
        }
        for (ConstraintDefinition constraintDef : propDef.getConstraints()) {
            Constraint constraint = constraintDef.getConstraint();
            if (constraint instanceof ListOfValuesConstraint) {
                this.addChoiceList((ListOfValuesConstraint)constraint, (PropertyDefinition<?>)result);
            }
            if (constraint instanceof StringLengthConstraint && result instanceof PropertyStringDefinitionImpl) {
                StringLengthConstraint slc = (StringLengthConstraint)constraint;
                ((PropertyStringDefinitionImpl)result).setMaxLength(BigInteger.valueOf(slc.getMaxLength()));
            }
            if (!(constraint instanceof NumericRangeConstraint)) continue;
            NumericRangeConstraint nrc = (NumericRangeConstraint)constraint;
            if (result instanceof PropertyIntegerDefinitionImpl) {
                ((PropertyIntegerDefinitionImpl)result).setMinValue(BigInteger.valueOf(Double.valueOf(nrc.getMinValue()).longValue()));
                ((PropertyIntegerDefinitionImpl)result).setMaxValue(BigInteger.valueOf(Double.valueOf(nrc.getMaxValue()).longValue()));
            }
            if (!(result instanceof PropertyDecimalDefinitionImpl)) continue;
            ((PropertyDecimalDefinitionImpl)result).setMinValue(BigDecimal.valueOf(nrc.getMinValue()));
            ((PropertyDecimalDefinitionImpl)result).setMaxValue(BigDecimal.valueOf(nrc.getMaxValue()));
        }
        return result;
    }

    protected void createActionEvaluators(PropertyAccessorMapping propertyAccessorMapping, BaseTypeId baseTypeId) {
        this.actionEvaluators = propertyAccessorMapping != null ? propertyAccessorMapping.getActionEvaluators(baseTypeId) : Collections.emptyMap();
    }

    private <T> T convertValueFromString(String value, PropertyType datatype) {
        if (value == null) {
            return null;
        }
        switch (datatype) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(value);
            }
            case DATETIME: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(ISO8601DateFormat.parse((String)value));
                return (T)cal;
            }
            case DECIMAL: {
                return (T)new BigDecimal(value);
            }
            case HTML: {
                return (T)value;
            }
            case ID: {
                return (T)value;
            }
            case INTEGER: {
                return (T)new BigInteger(value);
            }
            case STRING: {
                return (T)value;
            }
            case URI: {
                return (T)value;
            }
        }
        throw new RuntimeException("Unknown datatype! Spec change?");
    }

    private void addDefaultValue(String value, PropertyDefinition<?> propDef) {
        if (value == null) {
            return;
        }
        if (propDef instanceof PropertyBooleanDefinitionImpl) {
            PropertyBooleanDefinitionImpl propDefImpl = (PropertyBooleanDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((Boolean)this.convertValueFromString(value, PropertyType.BOOLEAN)));
        } else if (propDef instanceof PropertyDateTimeDefinitionImpl) {
            PropertyDateTimeDefinitionImpl propDefImpl = (PropertyDateTimeDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((GregorianCalendar)this.convertValueFromString(value, PropertyType.DATETIME)));
        } else if (propDef instanceof PropertyDecimalDefinitionImpl) {
            PropertyDecimalDefinitionImpl propDefImpl = (PropertyDecimalDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((BigDecimal)this.convertValueFromString(value, PropertyType.DECIMAL)));
        } else if (propDef instanceof PropertyHtmlDefinitionImpl) {
            PropertyHtmlDefinitionImpl propDefImpl = (PropertyHtmlDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((String)this.convertValueFromString(value, PropertyType.HTML)));
        } else if (propDef instanceof PropertyIdDefinitionImpl) {
            PropertyIdDefinitionImpl propDefImpl = (PropertyIdDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((String)this.convertValueFromString(value, PropertyType.ID)));
        } else if (propDef instanceof PropertyIntegerDefinitionImpl) {
            PropertyIntegerDefinitionImpl propDefImpl = (PropertyIntegerDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((BigInteger)this.convertValueFromString(value, PropertyType.INTEGER)));
        } else if (propDef instanceof PropertyStringDefinitionImpl) {
            PropertyStringDefinitionImpl propDefImpl = (PropertyStringDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((String)this.convertValueFromString(value, PropertyType.STRING)));
        } else if (propDef instanceof PropertyUriDefinitionImpl) {
            PropertyUriDefinitionImpl propDefImpl = (PropertyUriDefinitionImpl)propDef;
            propDefImpl.setDefaultValue(Collections.singletonList((String)this.convertValueFromString(value, PropertyType.URI)));
        }
    }

    private void addChoiceList(ListOfValuesConstraint lovc, PropertyDefinition<?> propDef) {
        if (propDef instanceof PropertyBooleanDefinitionImpl) {
            PropertyBooleanDefinitionImpl propDefImpl = (PropertyBooleanDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((Boolean)this.convertValueFromString(allowed, PropertyType.BOOLEAN)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyDateTimeDefinitionImpl) {
            PropertyDateTimeDefinitionImpl propDefImpl = (PropertyDateTimeDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((GregorianCalendar)this.convertValueFromString(allowed, PropertyType.DATETIME)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyDecimalDefinitionImpl) {
            PropertyDecimalDefinitionImpl propDefImpl = (PropertyDecimalDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((BigDecimal)this.convertValueFromString(allowed, PropertyType.DECIMAL)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyHtmlDefinitionImpl) {
            PropertyHtmlDefinitionImpl propDefImpl = (PropertyHtmlDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((String)this.convertValueFromString(allowed, PropertyType.HTML)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyIdDefinitionImpl) {
            PropertyIdDefinitionImpl propDefImpl = (PropertyIdDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((String)this.convertValueFromString(allowed, PropertyType.ID)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyIntegerDefinitionImpl) {
            PropertyIntegerDefinitionImpl propDefImpl = (PropertyIntegerDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((BigInteger)this.convertValueFromString(allowed, PropertyType.INTEGER)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyStringDefinitionImpl) {
            PropertyStringDefinitionImpl propDefImpl = (PropertyStringDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((String)this.convertValueFromString(allowed, PropertyType.STRING)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        } else if (propDef instanceof PropertyUriDefinitionImpl) {
            PropertyUriDefinitionImpl propDefImpl = (PropertyUriDefinitionImpl)propDef;
            propDefImpl.setIsOpenChoice(Boolean.valueOf(false));
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            for (String allowed : lovc.getAllowedValues()) {
                ChoiceImpl choice = new ChoiceImpl();
                choice.setDisplayName(allowed);
                choice.setValue(Collections.singletonList((String)this.convertValueFromString(allowed, PropertyType.URI)));
                choiceList.add(choice);
            }
            propDefImpl.setChoices(choiceList);
        }
    }
}

