/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.encoding;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class CharsetFinderTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private ContentCharsetFinder charsetFinder;

    public void setUp() throws Exception {
        this.charsetFinder = (ContentCharsetFinder)ctx.getBean("charset.finder");
    }

    public void testPlainText() throws Exception {
        String test = "The quick brown fox jumps over the lazy dog\n\nLe renard brun rapide saute par-dessus le chien paresseux\n\nDer schnelle braune Fuchs springt \u00fcber den faulen Hund\n\n\u0628\u0631\u0627\u0648\u0646 \u0648\u0643\u0633 \u0627\u0644\u0633\u0631\u064a\u0639 \u064a\u0642\u0641\u0632 \u0641\u0648\u0642 \u0627\u0644\u0643\u0644\u0628 \u0643\u0633\u0627\u0644\u064a";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UTF-8")));
        Charset charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-8", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UTF-16")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16BE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UnicodeBig")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16BE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UnicodeLittle")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16LE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UTF-32")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-32BE", (String)charset.displayName());
    }

    public void test8BitText() throws Exception {
        String for_iso_8859_1 = "En fran\u00e7ais o\u00f9 les choses sont accentu\u00e9s. En espa\u00f1ol, as\u00ed";
        String for_iso_8859_7 = "\u0391\u03c5\u03c4\u03cc \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c4\u03b7\u03bd \u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1";
        String for_cp1251 = "\u042d\u0442\u043e \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(for_iso_8859_1.getBytes("ISO-8859-1")));
        Charset charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"ISO-8859-1", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(for_iso_8859_7.getBytes("ISO-8859-7")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"ISO-8859-7", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(for_cp1251.getBytes("CP1251")));
        charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"windows-1251", (String)charset.displayName());
    }
}

