/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.acl.basic;

import java.util.Vector;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.acl.AclEntry;
import net.sf.acegisecurity.acl.basic.AbstractBasicAclEntry;
import net.sf.acegisecurity.acl.basic.BasicAclEntry;
import net.sf.acegisecurity.acl.basic.EffectiveAclsResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GrantedAuthorityEffectiveAclsResolver
implements EffectiveAclsResolver {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver == null ? (class$net$sf$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver = GrantedAuthorityEffectiveAclsResolver.class$("net.sf.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolver")) : class$net$sf$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver));
    static /* synthetic */ Class class$net$sf$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver;

    public AclEntry[] resolveEffectiveAcls(AclEntry[] allAcls, Authentication filteredBy) {
        if (allAcls == null || allAcls.length == 0) {
            return null;
        }
        Vector<AclEntry> list = new Vector<AclEntry>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locating AclEntry[]s (from set of " + (allAcls == null ? 0 : allAcls.length) + ") that apply to Authentication: " + filteredBy));
        }
        for (int i = 0; i < allAcls.length; ++i) {
            if (!(allAcls[i] instanceof AbstractBasicAclEntry)) continue;
            Object recipient = ((AbstractBasicAclEntry)allAcls[i]).getRecipient();
            if (filteredBy.getPrincipal().equals(recipient)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            if (filteredBy.getPrincipal() instanceof UserDetails && ((UserDetails)filteredBy.getPrincipal()).getUsername().equals(recipient)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Principal (from UserDetails) matches AclEntry recipient: " + recipient));
                }
                list.add(allAcls[i]);
                continue;
            }
            GrantedAuthority[] authorities = filteredBy.getAuthorities();
            if (authorities == null || authorities.length == 0) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Did not match principal and there are no granted authorities, so cannot compare with recipient: " + recipient));
                continue;
            }
            for (int k = 0; k < authorities.length; ++k) {
                if (!authorities[k].equals(recipient)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GrantedAuthority: " + authorities[k] + " matches recipient: " + recipient));
                }
                list.add(allAcls[i]);
            }
        }
        if (list.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning effective AclEntry array with " + list.size() + " elements"));
            }
            return list.toArray(new BasicAclEntry[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Returning null AclEntry array as zero effective AclEntrys found");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

