/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISStrictDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.mapping.RuntimePropertyLuceneBuilderMapping;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.parsers.AlfrescoFunctionEvaluationContext;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryModelFactory;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoDataType;
import org.alfresco.solr.ContextAwareQuery;
import org.alfresco.solr.PropertyDefinitionWrapper;
import org.alfresco.solr.SolrLuceneAnalyser;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.query.LuceneQueryBuilderContextSolrImpl;
import org.alfresco.solr.query.SolrQueryParser;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoSolrDataModel {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoSolrDataModel.class);
    private static HashMap<String, AlfrescoSolrDataModel> models = new HashMap();
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    public static HashMap<String, NonDictionaryField> nonDictionaryFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalContentFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalTextFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalMlTextFields = new HashMap();
    private TenantService tenantService;
    private NamespaceDAOImpl namespaceDAO;
    private DictionaryDAOImpl dictionaryDAO;
    private DictionaryComponent dictionaryComponent;
    private CMISStrictDictionaryService cmisDictionaryService;
    private boolean storeAll = false;
    private AlfrescoDataType alfrescoDataType;
    private String id;

    private static void addNonDictionaryField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        nonDictionaryFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalContentField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalContentFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalTextField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalTextFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalMlTextField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalMlTextFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlfrescoSolrDataModel getInstance(String id) {
        AlfrescoSolrDataModel model;
        readWriteLock.readLock().lock();
        try {
            model = models.get(id);
            if (model != null) {
                AlfrescoSolrDataModel alfrescoSolrDataModel = model;
                return alfrescoSolrDataModel;
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
        readWriteLock.writeLock().lock();
        try {
            model = models.get(id);
            if (model == null) {
                model = new AlfrescoSolrDataModel(id);
                models.put(id, model);
            }
            AlfrescoSolrDataModel alfrescoSolrDataModel = model;
            return alfrescoSolrDataModel;
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    private AlfrescoSolrDataModel(String id) {
        this.id = id;
        this.tenantService = new SingleTServiceImpl();
        this.namespaceDAO = new NamespaceDAOImpl();
        this.namespaceDAO.setTenantService(this.tenantService);
        this.namespaceDAO.setNamespaceRegistryCache((SimpleCache)new MemoryCache());
        this.dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)this.namespaceDAO);
        this.dictionaryDAO.setTenantService(this.tenantService);
        this.dictionaryDAO.setDictionaryRegistryCache((SimpleCache)new MemoryCache());
        this.dictionaryDAO.setDefaultAnalyserResourceBundleName("alfresco/model/dataTypeAnalyzers");
        this.dictionaryDAO.setResourceClassLoader(this.getResourceClassLoader());
        this.dictionaryComponent = new DictionaryComponent();
        this.dictionaryComponent.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        CMISMapping cmisMapping = new CMISMapping();
        DictionaryNamespaceComponent namespaceService = new DictionaryNamespaceComponent();
        namespaceService.setNamespaceDAO((NamespaceDAO)this.namespaceDAO);
        cmisMapping.setNamespaceService((NamespaceService)namespaceService);
        cmisMapping.setDictionaryService((DictionaryService)this.dictionaryComponent);
        cmisMapping.afterPropertiesSet();
        this.cmisDictionaryService = new CMISStrictDictionaryService();
        this.cmisDictionaryService.setCmisMapping(cmisMapping);
        this.cmisDictionaryService.setDictionaryService((DictionaryService)this.dictionaryComponent);
        this.cmisDictionaryService.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        this.cmisDictionaryService.setTenantService(this.tenantService);
        RuntimePropertyLuceneBuilderMapping luceneBuilderMapping = new RuntimePropertyLuceneBuilderMapping();
        luceneBuilderMapping.setDictionaryService((DictionaryService)this.dictionaryComponent);
        luceneBuilderMapping.setCmisDictionaryService((CMISDictionaryService)this.cmisDictionaryService);
        this.cmisDictionaryService.setPropertyLuceneBuilderMapping((PropertyLuceneBuilderMapping)luceneBuilderMapping);
        luceneBuilderMapping.afterPropertiesSet();
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryComponent;
    }

    public CMISDictionaryService getCMISDictionaryService() {
        return this.cmisDictionaryService;
    }

    public NamespaceDAO getNamespaceDAO() {
        return this.namespaceDAO;
    }

    public boolean isStoreAll() {
        return this.storeAll;
    }

    public void setStoreAll(boolean storeAll) {
        this.storeAll = storeAll;
    }

    public MLAnalysisMode getMLAnalysisMode() {
        return MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    }

    public boolean isIndexedOrStored(QName propertyQName) {
        if (this.storeAll) {
            return true;
        }
        String fieldName = "@" + propertyQName.toString();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(fieldName);
        if (propertyDefinition != null) {
            if (propertyDefinition.isIndexed()) {
                return true;
            }
            return propertyDefinition.isStoredInIndex();
        }
        return true;
    }

    public Field.Index getFieldIndex(SchemaField field) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            if (propertyDefinition.isIndexed()) {
                switch (propertyDefinition.getIndexTokenisationMode()) {
                    default: {
                        return Field.Index.ANALYZED;
                    }
                    case FALSE: 
                }
                return Field.Index.NOT_ANALYZED;
            }
            return Field.Index.NO;
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.index;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            return additionalContentFields.get(additionalContentFieldEnding).index;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            return additionalTextFields.get(additionalTextFieldEnding).index;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            return additionalMlTextFields.get(additionalMlTextFieldEnding).index;
        }
        return Field.Index.ANALYZED;
    }

    private PropertyDefinition getPropertyDefinition(String fieldName) {
        QName rawPropertyName = QName.createQName((String)fieldName.substring(1));
        QName propertyQName = QName.createQName((String)rawPropertyName.getNamespaceURI(), (String)ISO9075.decode((String)rawPropertyName.getLocalName()));
        return this.getPropertyDefinition(propertyQName);
    }

    public Field.Store getFieldStore(SchemaField field) {
        if (this.storeAll) {
            return Field.Store.YES;
        }
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            return propertyDefinition.isStoredInIndex() ? Field.Store.YES : Field.Store.NO;
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.store;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            return additionalContentFields.get(additionalContentFieldEnding).store;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            return additionalTextFields.get(additionalTextFieldEnding).store;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            return additionalMlTextFields.get(additionalMlTextFieldEnding).store;
        }
        return Field.Store.NO;
    }

    public Field.TermVector getFieldTermVec(SchemaField field) {
        return Field.TermVector.NO;
    }

    public boolean getOmitNorms(SchemaField field) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            return false;
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            nonDDField = additionalContentFields.get(additionalContentFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            nonDDField = additionalTextFields.get(additionalTextFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            nonDDField = additionalMlTextFields.get(additionalMlTextFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        return false;
    }

    public org.apache.lucene.search.Query getRangeQuery(SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        SolrLuceneAnalyser defaultAnalyser = new SolrLuceneAnalyser(this.getDictionaryService(), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
        SolrQueryParser parser = new SolrQueryParser("TEXT", (Analyzer)defaultAnalyser);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        parser.setNamespacePrefixResolver((NamespacePrefixResolver)this.namespaceDAO);
        parser.setDictionaryService(this.getDictionaryService());
        parser.setTenantService(this.tenantService);
        parser.setSearchParameters(null);
        parser.setDefaultSearchMLAnalysisMode(this.getMLAnalysisMode());
        parser.setIndexReader(null);
        parser.setAllowLeadingWildcard(true);
        try {
            return parser.getRangeQuery(field.getName(), part1, part2, minInclusive, maxInclusive, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        catch (ParseException e) {
            throw new AlfrescoRuntimeException("Parse error building range query", (Throwable)e);
        }
    }

    public void putModel(M2Model model) {
        this.dictionaryDAO.putModelIgnoringConstraints(model);
    }

    public M2Model getM2Model(QName modelQName) {
        return this.dictionaryDAO.getCompiledModel(modelQName).getM2Model();
    }

    public void afterInitModels() {
        this.cmisDictionaryService.afterDictionaryInit();
    }

    public AbstractLuceneQueryParser getLuceneQueryParser(SearchParameters searchParameters, IndexReader indexReader) {
        SolrLuceneAnalyser analyzer = new SolrLuceneAnalyser(this.getDictionaryService(), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
        SolrQueryParser parser = new SolrQueryParser(searchParameters.getDefaultFieldName(), (Analyzer)analyzer);
        QueryParser.Operator defaultOperator = searchParameters.getDefaultOperator() == SearchParameters.AND ? LuceneQueryParser.AND_OPERATOR : LuceneQueryParser.OR_OPERATOR;
        parser.setDefaultOperator(defaultOperator);
        parser.setNamespacePrefixResolver((NamespacePrefixResolver)this.namespaceDAO);
        parser.setDictionaryService((DictionaryService)this.dictionaryComponent);
        parser.setTenantService(this.tenantService);
        parser.setSearchParameters(searchParameters);
        parser.setDefaultSearchMLAnalysisMode(this.getMLAnalysisMode());
        parser.setIndexReader(indexReader);
        parser.setAllowLeadingWildcard(true);
        return parser;
    }

    public LuceneQueryBuilderContext getLuceneQueryBuilderContext(SearchParameters searchParameters, IndexReader indexReader) {
        LuceneQueryBuilderContextSolrImpl luceneContext = new LuceneQueryBuilderContextSolrImpl((DictionaryService)this.dictionaryComponent, (NamespacePrefixResolver)this.namespaceDAO, this.tenantService, searchParameters, this.getMLAnalysisMode(), indexReader, (Analyzer)this.alfrescoDataType.getAnalyzer(), this);
        return luceneContext;
    }

    public org.apache.lucene.search.Query getFTSQuery(SearchParameters searchParameters, IndexReader indexReader) throws ParseException {
        LuceneQueryModelFactory factory = new LuceneQueryModelFactory();
        AlfrescoFunctionEvaluationContext functionContext = new AlfrescoFunctionEvaluationContext((NamespacePrefixResolver)this.namespaceDAO, (DictionaryService)this.dictionaryComponent, "http://www.alfresco.org/model/content/1.0");
        FTSParser.Mode mode = searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.AND ? FTSParser.Mode.DEFAULT_CONJUNCTION : FTSParser.Mode.DEFAULT_DISJUNCTION;
        Constraint constraint = FTSQueryParser.buildFTS((String)searchParameters.getQuery(), (QueryModelFactory)factory, (FunctionEvaluationContext)functionContext, null, null, (FTSParser.Mode)mode, (QueryOptions.Connective)(searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND), (Map)searchParameters.getQueryTemplates(), (String)searchParameters.getDefaultFieldName());
        Query queryModelQuery = factory.createQuery(null, null, constraint, new ArrayList());
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        LuceneQueryBuilderContext luceneContext = this.getLuceneQueryBuilderContext(searchParameters, indexReader);
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        org.apache.lucene.search.Query luceneQuery = builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        ContextAwareQuery contextAwareQuery = new ContextAwareQuery(luceneQuery, searchParameters);
        return contextAwareQuery;
    }

    public Query parseCMISQueryToAlfrescoAbstractQuery(CMISQueryOptions.CMISQueryMode mode, SearchParameters searchParameters, IndexReader indexReader) throws ParseException {
        CMISQueryOptions options = new CMISQueryOptions(searchParameters.getQuery(), StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setLocales(searchParameters.getLocales());
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setQueryParameterDefinitions((List)searchParameters.getQueryParameterDefinitions());
        CapabilityJoin joinSupport = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CapabilityJoin.NONE : CapabilityJoin.INNERONLY;
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode);
        CMISQueryParser parser = new CMISQueryParser(options, (CMISDictionaryService)this.cmisDictionaryService, joinSupport);
        Query queryModelQuery = parser.parse((QueryModelFactory)new LuceneQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        return queryModelQuery;
    }

    public CmisFunctionEvaluationContext getCMISFunctionEvaluationContext(CMISQueryOptions.CMISQueryMode mode) {
        BaseTypeId[] validScopes = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService((CMISDictionaryService)this.cmisDictionaryService);
        functionContext.setValidScopes(validScopes);
        return functionContext;
    }

    public org.apache.lucene.search.Query getCMISQuery(CMISQueryOptions.CMISQueryMode mode, SearchParameters searchParameters, IndexReader indexReader, Query queryModelQuery) throws ParseException {
        BaseTypeId[] validScopes = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode);
        Set selectorGroup = (Set)queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext).get(0);
        LuceneQueryBuilderContext luceneContext = this.getLuceneQueryBuilderContext(searchParameters, indexReader);
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        org.apache.lucene.search.Query luceneQuery = builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        ContextAwareQuery contextAwareQuery = new ContextAwareQuery(luceneQuery, searchParameters);
        return contextAwareQuery;
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return Sorting.getStringSortField((String)(field.getName() + ".sort"), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return new SortField(field.getName() + ".sort", (FieldComparatorSource)new TextSortFieldComparatorSource(), reverse);
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return new SortField(field.getName() + ".sort", (FieldComparatorSource)new MLTextSortFieldComparatorSource(), reverse);
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            return Sorting.getStringSortField((String)field.getName(), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return Sorting.getStringSortField((String)field.getName(), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        return Sorting.getStringSortField((String)field.getName(), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
    }

    public void setAlfrescoDataType(AlfrescoDataType alfrescoDataType) {
        this.alfrescoDataType = alfrescoDataType;
    }

    public List<AlfrescoModel> getAlfrescoModels() {
        ArrayList<AlfrescoModel> answer = new ArrayList<AlfrescoModel>();
        for (QName modelName : this.dictionaryDAO.getModels()) {
            M2Model m2Model = this.dictionaryDAO.getCompiledModel(modelName).getM2Model();
            answer.add(new AlfrescoModel(m2Model, this.dictionaryComponent.getModel(modelName).getChecksum(ModelDefinition.XMLBindingType.DEFAULT)));
        }
        return answer;
    }

    public SolrLuceneAnalyser getSolrLuceneAnalyser() {
        return new SolrLuceneAnalyser(this.getDictionaryService(), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
    }

    public ClassLoader getResourceClassLoader() {
        File f = new File(this.id, "alfrescoResources");
        if (f.canRead() && f.isDirectory()) {
            URL[] urls = new URL[1];
            try {
                URL url;
                urls[0] = url = f.toURI().normalize().toURL();
            }
            catch (MalformedURLException e) {
                throw new AlfrescoRuntimeException("Failed to add resources to classpath ", (Throwable)e);
            }
            return URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        }
        return this.getClass().getClassLoader();
    }

    public Analyzer getQueryAnalyser() {
        return this.getSolrLuceneAnalyser();
    }

    public PropertyDefinition getPropertyDefinition(QName propertyQName) {
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyQName);
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_AUTHOR)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_CREATOR)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_MODIFIER)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        return propertyDef;
    }

    static {
        AlfrescoSolrDataModel.addNonDictionaryField("ID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("LID", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("TX", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("PARENT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("LINKASPECT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PATH", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ANCESTOR", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ISCONTAINER", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ISCATEGORY", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("QNAME", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYASSOCQNAME", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ISROOT", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYASSOCTYPEQNAME", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ISNODE", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ASSOCTYPEQNAME", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYPARENT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TYPE", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ASPECT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("FTSSTATUS", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("DBID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("INTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("INACLTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TXCOMMITTIME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLTXCOMMITTIME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("READER", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("OWNER", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PARENTASSOCCRC", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalContentField(".size", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".locale", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".mimetype", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".encoding", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".contentDocId", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationException", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationTime", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationStatus", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalTextField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".u", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".__.u", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".sort", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".u", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".__.u", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".sort", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, false);
    }

    public static final class MLTextSortFieldComparator
    extends FieldComparator {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;
        Locale collatorLocale;

        MLTextSortFieldComparator(int numHits, String field, Locale collatorLocale) {
            this.values = new String[numHits];
            this.field = field;
            this.collatorLocale = collatorLocale;
            this.collator = Collator.getInstance(collatorLocale);
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        public int compareBottom(int doc) {
            String val2 = this.findBestValue(this.currentReaderValues[doc]);
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, val2);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.findBestValue(this.currentReaderValues[doc]);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable value(int slot) {
            return this.values[slot];
        }

        private String findBestValue(String withLocale) {
            if (withLocale == null) {
                return withLocale;
            }
            if (withLocale.startsWith("\u0000")) {
                MLText mlText = new MLText();
                String[] parts = withLocale.split("\u0000");
                int i = 0;
                while (i + 2 <= parts.length) {
                    Locale locale = null;
                    String[] localeParts = parts[i + 1].split("_");
                    if (localeParts.length == 1) {
                        locale = new Locale(localeParts[0]);
                    } else if (localeParts.length == 2) {
                        locale = new Locale(localeParts[0], localeParts[1]);
                    } else if (localeParts.length == 3) {
                        locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                    }
                    if (locale != null) {
                        if (i + 2 == parts.length) {
                            mlText.addValue(locale, "");
                        } else {
                            mlText.addValue(locale, parts[i + 2]);
                        }
                    }
                    i += 3;
                }
                return mlText.getClosestValue(this.collatorLocale);
            }
            return withLocale;
        }
    }

    public static class MLTextSortFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new MLTextSortFieldComparator(numHits, fieldname, I18NUtil.getLocale());
        }
    }

    public static final class TextSortFieldComparator
    extends FieldComparator {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;

        TextSortFieldComparator(int numHits, String field, Locale locale) {
            this.values = new String[numHits];
            this.field = field;
            this.collator = Collator.getInstance(locale);
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        public int compareBottom(int doc) {
            String val2 = this.stripLocale(this.currentReaderValues[doc]);
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, val2);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.stripLocale(this.currentReaderValues[doc]);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable value(int slot) {
            return this.values[slot];
        }

        private String stripLocale(String withLocale) {
            if (withLocale == null) {
                return withLocale;
            }
            if (withLocale.startsWith("\u0000")) {
                return withLocale.substring(withLocale.indexOf(0, 1) + 1);
            }
            return withLocale;
        }
    }

    public static class TextSortFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new TextSortFieldComparator(numHits, fieldname, I18NUtil.getLocale());
        }
    }

    private static class NonDictionaryField {
        private String name;
        private Field.Store store;
        private Field.Index index;
        private Field.TermVector termVector;
        private boolean multiValued;

        public NonDictionaryField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
            this.name = name;
            this.store = store;
            this.index = index;
            this.termVector = termVector;
            this.multiValued = multiValued;
        }
    }
}

