/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrDocumentLoaderTest
extends TestCase {
    public void testDeepPath() throws SolrServerException, IOException {
        SolrServer solr = this.getRemoteServer();
        solr.deleteByQuery("*:*");
        solr.commit(true, true);
        solr.optimize(true, true);
        long start = System.nanoTime();
        SolrInputDocument acl0 = this.createTestAcl(0, new String[]{"andy", "GROUP_MONKEY", "ROLE_ADMIN", "bob"});
        solr.add(acl0);
        SolrInputDocument root = this.createTestPathRoot(0);
        solr.add(root);
        SolrInputDocument rootAux = this.createTestPathRootAux(0, 0);
        solr.add(rootAux);
        String path = "";
        path = this.addDeepPair(solr, 1, path, "{http://www.alfresco.org/model/content/1.0}one");
        path = this.addDeepPair(solr, 2, path, "{http://www.alfresco.org/model/content/1.0}two");
        path = this.addDeepPair(solr, 3, path, "{http://www.alfresco.org/model/content/1.0}three");
        path = this.addDeepPair(solr, 4, path, "{http://www.alfresco.org/model/content/1.0}four");
        path = this.addDeepPair(solr, 5, path, "{http://www.alfresco.org/model/content/1.0}five");
        path = this.addDeepPair(solr, 6, path, "{http://www.alfresco.org/model/content/1.0}six");
        path = this.addDeepPair(solr, 7, path, "{http://www.alfresco.org/model/content/1.0}seven");
        path = this.addDeepPair(solr, 8, path, "{http://www.alfresco.org/model/content/1.0}eight");
        path = this.addDeepPair(solr, 9, path, "{http://www.alfresco.org/model/content/1.0}nine");
        path = this.addDeepPair(solr, 10, path, "{http://www.alfresco.org/model/content/1.0}ten");
        path = this.addDeepPair(solr, 11, path, "{http://www.alfresco.org/model/content/1.0}eleven");
        path = this.addDeepPair(solr, 12, path, "{http://www.alfresco.org/model/content/1.0}twelve");
        path = this.addDeepPair(solr, 13, path, "{http://www.alfresco.org/model/content/1.0}thirteen");
        path = this.addDeepPair(solr, 14, path, "{http://www.alfresco.org/model/content/1.0}fourteen");
        path = this.addDeepPair(solr, 15, path, "{http://www.alfresco.org/model/content/1.0}fifteen");
        path = this.addDeepPair(solr, 16, path, "{http://www.alfresco.org/model/content/1.0}sixteen");
        path = this.addDeepPair(solr, 17, path, "{http://www.alfresco.org/model/content/1.0}seventeen");
        path = this.addDeepPair(solr, 18, path, "{http://www.alfresco.org/model/content/1.0}eighteeen");
        path = this.addDeepPair(solr, 19, path, "{http://www.alfresco.org/model/content/1.0}nineteen");
        path = this.addDeepPair(solr, 20, path, "{http://www.alfresco.org/model/content/1.0}twenty");
        path = this.addDeepPair(solr, 21, path, "{http://www.alfresco.org/model/content/1.0}twenty-one");
        path = this.addDeepPair(solr, 22, path, "{http://www.alfresco.org/model/content/1.0}twenty-two");
        path = this.addDeepPair(solr, 23, path, "{http://www.alfresco.org/model/content/1.0}twenty-three");
        path = this.addDeepPair(solr, 24, path, "{http://www.alfresco.org/model/content/1.0}twenty-four");
        path = this.addDeepPair(solr, 25, path, "{http://www.alfresco.org/model/content/1.0}twenty-five");
        path = this.addDeepPair(solr, 26, path, "{http://www.alfresco.org/model/content/1.0}twenty-six");
        path = this.addDeepPair(solr, 27, path, "{http://www.alfresco.org/model/content/1.0}twenty-seven");
        path = this.addDeepPair(solr, 28, path, "{http://www.alfresco.org/model/content/1.0}twenty-eight");
        path = this.addDeepPair(solr, 29, path, "{http://www.alfresco.org/model/content/1.0}twenty-nine");
        path = this.addDeepPair(solr, 30, path, "{http://www.alfresco.org/model/content/1.0}thirty");
        solr.commit(true, true);
        solr.optimize(true, true);
        long end = System.nanoTime();
        SolrQuery query = new SolrQuery("*:*");
        QueryResponse response = solr.query((SolrParams)query);
        SolrDocumentLoaderTest.assertEquals((long)63L, (long)response.getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:thirty\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-nine\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-eight\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-seven\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-six\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-four\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-three\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-two\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*//*//cm:twenty-one\"}")).getResults().getNumFound());
    }

    private String addDeepPair(SolrServer solr, int dbid, String path, String qname) throws SolrServerException, IOException {
        StringBuilder builder = new StringBuilder(path);
        builder.append("/").append(qname);
        String newPath = builder.toString();
        solr.add(this.createTestPathDocument(dbid, this.asArray("" + (dbid - 1)), this.asArray(qname), this.repeatAsArray(dbid, false, "{http://www.alfresco.org/model/system/1.0}children"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(dbid)));
        solr.add(this.createTestPathDocumentAux(dbid, this.repeatAsArray(dbid, true, newPath), this.asArray(this.getDeepParents(dbid)), 0));
        return newPath;
    }

    private String[] repeatAsArray(int dbid, boolean prefix, String string) {
        String[] array = new String[dbid];
        for (int i = 0; i < dbid; ++i) {
            array[i] = prefix ? "/{http://www.alfresco.org/model/content/1.0}repeat-" + i + string : string;
        }
        return array;
    }

    private String[] getDeepParents(int dbid) {
        String[] parents = new String[dbid];
        for (int i = 0; i < dbid; ++i) {
            parents[i] = "" + i;
        }
        return parents;
    }

    public void testPath() throws SolrServerException, IOException {
        SolrServer solr = this.getRemoteServer();
        solr.deleteByQuery("*:*");
        solr.commit(true, true);
        solr.optimize(true, true);
        long start = System.nanoTime();
        SolrInputDocument acl0 = this.createTestAcl(0, new String[]{"andy", "GROUP_MONKEY", "ROLE_ADMIN", "bob"});
        solr.add(acl0);
        SolrInputDocument root = this.createTestPathRoot(0);
        solr.add(root);
        SolrInputDocument rootAux = this.createTestPathRootAux(0, 0);
        solr.add(rootAux);
        solr.add(this.createTestPathDocument(1, this.asArray("0"), this.asArray("{http://www.alfresco.org/model/content/1.0}one"), this.asArray("{http://www.alfresco.org/model/system/1.0}children"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(1)));
        solr.add(this.createTestPathDocumentAux(1, this.asArray("/{http://www.alfresco.org/model/content/1.0}one"), this.asArray("0"), 0));
        solr.add(this.createTestPathDocument(2, this.asArray("0"), this.asArray("{http://www.alfresco.org/model/content/1.0}two"), this.asArray("{http://www.alfresco.org/model/system/1.0}children"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(2)));
        solr.add(this.createTestPathDocumentAux(2, this.asArray("/{http://www.alfresco.org/model/content/1.0}two"), this.asArray("0"), 0));
        solr.add(this.createTestPathDocument(3, this.asArray("0"), this.asArray("{http://www.alfresco.org/model/content/1.0}three"), this.asArray("{http://www.alfresco.org/model/system/1.0}children"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(3)));
        solr.add(this.createTestPathDocumentAux(3, this.asArray("/{http://www.alfresco.org/model/content/1.0}three"), this.asArray("0"), 0));
        solr.add(this.createTestPathDocument(4, this.asArray("0"), this.asArray("{http://www.alfresco.org/model/content/1.0}four"), this.asArray("{http://www.alfresco.org/model/system/1.0}children"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(4)));
        solr.add(this.createTestPathDocumentAux(4, this.asArray("/{http://www.alfresco.org/model/content/1.0}four"), this.asArray("0"), 0));
        solr.add(this.createTestPathDocument(5, this.asArray("1"), this.asArray("{http://www.alfresco.org/model/content/1.0}five"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(5)));
        solr.add(this.createTestPathDocumentAux(5, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five"), this.asArray("0", "1"), 0));
        solr.add(this.createTestPathDocument(6, this.asArray("1"), this.asArray("{http://www.alfresco.org/model/content/1.0}six"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(6)));
        solr.add(this.createTestPathDocumentAux(6, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}six"), this.asArray("0", "1"), 0));
        solr.add(this.createTestPathDocument(7, this.asArray("2"), this.asArray("{http://www.alfresco.org/model/content/1.0}seven"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(7)));
        solr.add(this.createTestPathDocumentAux(7, this.asArray("/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}seven"), this.asArray("0", "2"), 0));
        solr.add(this.createTestPathDocument(8, this.asArray("2", "0", "1"), this.asArray("{http://www.alfresco.org/model/content/1.0}eight-2", "{http://www.alfresco.org/model/content/1.0}eight-0", "{http://www.alfresco.org/model/content/1.0}eight-1"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/system/1.0}children", "{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(8)));
        solr.add(this.createTestPathDocumentAux(8, this.asArray("/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}eight-2", "/{http://www.alfresco.org/model/content/1.0}eight-0", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}eight-1"), this.asArray("0", "1", "2"), 0));
        solr.add(this.createTestPathDocument(9, this.asArray("5"), this.asArray("{http://www.alfresco.org/model/content/1.0}nine"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(9)));
        solr.add(this.createTestPathDocumentAux(9, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}nine"), this.asArray("0", "1", "5"), 0));
        solr.add(this.createTestPathDocument(10, this.asArray("5"), this.asArray("{http://www.alfresco.org/model/content/1.0}ten"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(10)));
        solr.add(this.createTestPathDocumentAux(10, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}ten"), this.asArray("0", "1", "5"), 0));
        solr.add(this.createTestPathDocument(11, this.asArray("5"), this.asArray("{http://www.alfresco.org/model/content/1.0}eleven"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(11)));
        solr.add(this.createTestPathDocumentAux(11, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}eleven"), this.asArray("0", "1", "5"), 0));
        solr.add(this.createTestPathDocument(12, this.asArray("5"), this.asArray("{http://www.alfresco.org/model/content/1.0}twelve"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(12)));
        solr.add(this.createTestPathDocumentAux(12, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve"), this.asArray("0", "1", "5"), 0));
        solr.add(this.createTestPathDocument(13, this.asArray("12", "2"), this.asArray("{http://www.alfresco.org/model/content/1.0}thirteen", "{http://www.alfresco.org/model/content/1.0}link"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(13)));
        solr.add(this.createTestPathDocumentAux(13, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve/{http://www.alfresco.org/model/content/1.0}thirteen", "/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}link"), this.asArray("0", "1", "5", "12", "2"), 0));
        solr.add(this.createTestPathDocument(14, this.asArray("13", "1", "2", "5", "6", "12", "13"), this.asArray("{http://www.alfresco.org/model/content/1.0}fourteen", "{http://www.alfresco.org/model/content/1.0}common", "{http://www.alfresco.org/model/content/1.0}common", "{http://www.alfresco.org/model/content/1.0}common", "{http://www.alfresco.org/model/content/1.0}common", "{http://www.alfresco.org/model/content/1.0}common", "{http://www.alfresco.org/model/content/1.0}common"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains", "{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(14)));
        solr.add(this.createTestPathDocumentAux(14, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve/{http://www.alfresco.org/model/content/1.0}thirteen/{http://www.alfresco.org/model/content/1.0}fourteen", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}link/{http://www.alfresco.org/model/content/1.0}fourteen", "/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}link/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}six/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve/{http://www.alfresco.org/model/content/1.0}common", "/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve/{http://www.alfresco.org/model/content/1.0}thirteen/{http://www.alfresco.org/model/content/1.0}common"), this.asArray("0", "1", "5", "12", "13", "2", "6"), 0));
        solr.add(this.createTestPathDocument(15, this.asArray("13"), this.asArray("{http://www.alfresco.org/model/content/1.0}fifteen"), this.asArray("{http://www.alfresco.org/model/content/1.0}contains"), "{http://www.alfresco.org/model/content/1.0}folder", this.asArray("{http://www.alfresco.org/model/content/1.0}auditable"), this.createProperties(15)));
        solr.add(this.createTestPathDocumentAux(15, this.asArray("/{http://www.alfresco.org/model/content/1.0}one/{http://www.alfresco.org/model/content/1.0}five/{http://www.alfresco.org/model/content/1.0}twelve/{http://www.alfresco.org/model/content/1.0}thirteen/{http://www.alfresco.org/model/content/1.0}fifteen", "/{http://www.alfresco.org/model/content/1.0}two/{http://www.alfresco.org/model/content/1.0}link/{http://www.alfresco.org/model/content/1.0}fifteen"), this.asArray("0", "1", "5", "12", "13"), 0));
        solr.commit(true, true);
        solr.optimize(true, true);
        long end = System.nanoTime();
        SolrQuery query = new SolrQuery("*:*");
        QueryResponse response = solr.query((SolrParams)query);
        SolrDocumentLoaderTest.assertEquals((long)33L, (long)response.getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:three\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:four\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:eight-0\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:one\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:two\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:one\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:two\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:six\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:seven\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:eight-1\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:eight-2\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:eight-2\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:eight-1\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:two/cm:eight-0\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)0L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:eight-0\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:nine\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:ten\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:eleven\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:twelve\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:fourteen\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:common\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five/cm:twelve/cm:common\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)5L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)5L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)6L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:*/cm:*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)6L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*/*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:*/cm:five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*/cm:five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)6L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:*/cm:*/cm:*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)6L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*/*/*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)4L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)4L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)5L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:*/cm:five/cm:*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)5L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*/cm:five/*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:*/cm:nine\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/*/cm:nine\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/*/cm:five\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)16L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)15L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)15L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*/.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)15L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//*/./.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)15L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//./*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)15L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//././*/././.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"//cm:common\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one//cm:common\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)7L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five//*\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)8L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one/cm:five//.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one//cm:five/cm:nine\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one//cm:thirteen/cm:fourteen\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one//cm:thirteen/cm:fourteen//.\"}")).getResults().getNumFound());
        SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"/cm:one//cm:thirteen/cm:fourteen//.//.\"}")).getResults().getNumFound());
        this.testAllPathsTo(solr, "", false, "cm:one");
        this.testAllPathsTo(solr, "", false, "cm:two");
        this.testAllPathsTo(solr, "", false, "cm:three");
        this.testAllPathsTo(solr, "", false, "cm:four");
        this.testAllPathsTo(solr, "", false, "cm:eight-0");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:six");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:eight-1");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:seven");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:eight-2");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:link");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:nine");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:ten");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:eleven");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:six", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve", "cm:thirteen");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve", "cm:thirteen", "cm:fourteen");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve", "cm:thirteen", "cm:fifteen");
        this.testAllPathsTo(solr, "", false, "cm:one", "cm:five", "cm:twelve", "cm:thirteen", "cm:common");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:link", "cm:fourteen");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:link", "cm:fifteen");
        this.testAllPathsTo(solr, "", false, "cm:two", "cm:link", "cm:common");
        System.out.println("Time " + (double)(end - start) / 1.0E9);
    }

    private void testAllPathsTo(SolrServer solr, String path, boolean nextDescendantsOnly, String ... parts) throws SolrServerException {
        if (parts.length > 1) {
            String[] tail = new String[parts.length - 1];
            System.arraycopy(parts, 1, tail, 0, tail.length);
            this.testAllPathsTo(solr, path, true, tail);
            if (!nextDescendantsOnly) {
                this.testAllPathsTo(solr, path + "/" + parts[0], false, tail);
                this.testAllPathsTo(solr, path + "/*", false, tail);
            }
            this.testAllPathsTo(solr, path + "//" + parts[0], false, tail);
            this.testAllPathsTo(solr, path + "//*", false, tail);
        } else {
            if (!nextDescendantsOnly) {
                System.out.println("{!afts v=PATH:\"" + path + "/" + parts[0] + "\"}");
                SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"" + path + "/" + parts[0] + "\"}")).getResults().getNumFound());
                System.out.println("{!afts v=PATH:\"" + path + "/" + parts[0] + "/.\"}");
                SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"" + path + "/" + parts[0] + "/.\"}")).getResults().getNumFound());
            }
            System.out.println("{!afts v=PATH:\"" + path + "//" + parts[0] + "\"}");
            SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"" + path + "//" + parts[0] + "\"}")).getResults().getNumFound());
            System.out.println("{!afts v=PATH:\"" + path + "//" + parts[0] + "/.\"}");
            SolrDocumentLoaderTest.assertEquals((long)1L, (long)solr.query((SolrParams)new SolrQuery("{!afts v=PATH:\"" + path + "//" + parts[0] + "/.\"}")).getResults().getNumFound());
        }
    }

    private String[] asArray(String ... string) {
        return string;
    }

    private Map<QName, String> createProperties(int doc) {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_LOCALE, "en");
        properties.put(ContentModel.PROP_TITLE, "Document Number " + doc);
        properties.put(ContentModel.PROP_NAME, "Doc " + doc);
        properties.put(ContentModel.PROP_CREATED, "2010-07-21T10:52:00.000Z");
        properties.put(ContentModel.PROP_CREATOR, "Andy");
        properties.put(ContentModel.PROP_MODIFIED, "2010-07-22T10:52:00.000Z");
        properties.put(ContentModel.PROP_MODIFIER, "Bob");
        return properties;
    }

    public void testBulkLoad() throws SolrServerException, IOException {
        int FOLDERS = 10000;
        int LEAVES = 100;
        SolrServer solr = this.getRemoteServer();
        solr.deleteByQuery("*:*");
        solr.commit(true, true);
        solr.optimize(true, true);
        int dbid = 0;
        SolrInputDocument root = this.createRootDocument(dbid);
        solr.add(root);
        SolrInputDocument rootPath = this.createRootPathDocument(dbid++);
        solr.add(rootPath);
        solr.commit(true, true);
        solr.optimize(true, true);
        SolrQuery query = new SolrQuery("*:*");
        QueryResponse response = solr.query((SolrParams)query);
        assert (2 == response.getResults().size());
        long start = System.nanoTime();
        for (int i = 0; i < FOLDERS; ++i) {
            ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
            docs.add(this.createContainerDocument(dbid, i));
            docs.add(this.createContainerPathDocument(dbid++, i));
            for (int j = 0; j < LEAVES; ++j) {
                docs.add(this.createLeafDocument(dbid, i, j));
                docs.add(this.createLeafPathDocument(dbid++, i, j));
            }
            solr.add(docs);
        }
        solr.commit(true, true);
        solr.optimize(true, true);
        long end = System.nanoTime();
        query = new SolrQuery("*:*");
        response = solr.query((SolrParams)query);
        System.out.println("Time " + (double)(end - start) / 1.0E9);
        assert (FOLDERS * (LEAVES + 1) + 2 == response.getResults().size());
        System.out.println("Done " + (FOLDERS * (LEAVES + 1) + 2));
    }

    public SolrInputDocument createLeafDocument(int dbid, int i, int j) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("PARENT", (Object)("ID-F-" + i));
        doc.addField("QNAME", (Object)("{http://www.alfresco.org/model/content/1.0}leaf-" + j));
        doc.addField("PRIMARYPARENT", (Object)("ID-F-" + i));
        doc.addField("ASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/content/1.0}contains");
        doc.addField("PRIMARYASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/content/1.0}contains");
        doc.addField("ANCESTOR", (Object)("ID-F-" + i));
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("ID-L-" + i + "-" + j));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"F");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)dbid);
        doc.addField("TYPE", (Object)"{http://www.alfresco.org/model/content/1.0}folder");
        doc.addField("ASPECT", (Object)"{http://www.alfresco.org/model/content/1.0}auditable");
        doc.addField("@{http://www.alfresco.org/model/system/1.0}locale", (Object)"en");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}title", (Object)("Leaf " + i + " " + j));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}name", (Object)("Folder " + i + " " + j));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}created", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}creator", (Object)"Andy");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modified", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modifier", (Object)"Andy");
        return doc;
    }

    public SolrInputDocument createLeafPathDocument(int dbid, int i, int j) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)("ID-L-" + i + "-" + j + "-Path"));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        QName first = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("folder_" + i));
        QName second = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("leaf_" + j));
        doc.addField("PATH", (Object)("/" + ISO9075.getXPathName((QName)first) + "/" + ISO9075.getXPathName((QName)second)));
        return doc;
    }

    public SolrInputDocument createContainerDocument(int dbid, int i) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("PARENT", (Object)"Root");
        doc.addField("QNAME", (Object)("{http://www.alfresco.org/model/content/1.0}folder-" + i));
        doc.addField("PRIMARYPARENT", (Object)"Root");
        doc.addField("ASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/system/1.0}children");
        doc.addField("PRIMARYASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/system/1.0}children");
        doc.addField("ANCESTOR", (Object)"Root");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("ID-F-" + i));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"T");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("TYPE", (Object)"{http://www.alfresco.org/model/content/1.0}folder");
        doc.addField("ASPECT", (Object)"{http://www.alfresco.org/model/content/1.0}auditable");
        doc.addField("@{http://www.alfresco.org/model/system/1.0}locale", (Object)"en");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}title", (Object)("Folder " + i));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}name", (Object)("Folder " + i));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}created", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}creator", (Object)"Andy");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modified", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modifier", (Object)"Andy");
        return doc;
    }

    public SolrInputDocument createContainerPathDocument(int dbid, int i) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)("ID-F-" + i + "-Path"));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        QName first = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("folder_" + i));
        doc.addField("PATH", (Object)("/" + ISO9075.getXPathName((QName)first)));
        return doc;
    }

    public SolrInputDocument createRootDocument(int dbid) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)"Root");
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"T");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        return doc;
    }

    public SolrInputDocument createRootPathDocument(int dbid) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("PATH", (Object)"/");
        doc.addField("ID", (Object)"Root-Path");
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        return doc;
    }

    public SolrServer getRemoteServer() throws MalformedURLException {
        CommonsHttpSolrServer solr = new CommonsHttpSolrServer("http://localhost:8080/solr/test");
        solr.setRequestWriter((RequestWriter)new BinaryRequestWriter());
        return solr;
    }

    public SolrInputDocument createTestPathRoot(int dbid) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)"Root");
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"T");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        return doc;
    }

    public SolrInputDocument createTestPathRootAux(int dbid, int acl) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)"Root-Path");
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("PATH", (Object)"/");
        return doc;
    }

    public SolrInputDocument createTestAcl(int acl, String[] readers) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ID", (Object)("ACL-" + acl));
        for (String reader : readers) {
        }
        return doc;
    }

    public SolrInputDocument createTestPathDocument(int dbid, String[] parents, String[] qnames, String[] assocTypeQnames, String type, String[] aspects, Map<QName, String> properties) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        for (String parent : parents) {
            doc.addField("PARENT", (Object)parent);
        }
        for (String qname : qnames) {
            doc.addField("QNAME", (Object)qname);
        }
        doc.addField("PRIMARYPARENT", (Object)parents[0]);
        for (String assocTypeQname : assocTypeQnames) {
            doc.addField("ASSOCTYPEQNAME", (Object)assocTypeQname);
        }
        doc.addField("PRIMARYASSOCTYPEQNAME", (Object)assocTypeQnames[0]);
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("ID-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"F");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("TYPE", (Object)type);
        for (String aspect : aspects) {
            doc.addField("ASPECT", (Object)aspect);
        }
        for (QName qname : properties.keySet()) {
            doc.addField("@" + qname, (Object)properties.get(qname));
        }
        return doc;
    }

    public SolrInputDocument createTestPathDocumentAux(int dbid, String[] paths, String[] ancestors, int acl) {
        SolrInputDocument doc = new SolrInputDocument();
        for (String ancestor : ancestors) {
            doc.addField("ANCESTOR", (Object)ancestor);
        }
        doc.addField("ID", (Object)("ID-" + dbid + "-Path"));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        for (String path : paths) {
            doc.addField("PATH", (Object)path);
        }
        return doc;
    }
}

